/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.java.parser.html;

import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.parser.ParserHandlersList;
import org.testingisdocumenting.znai.parser.commonmark.MarkdownParser;
import org.testingisdocumenting.znai.parser.docelement.DocElement;
import org.testingisdocumenting.znai.parser.docelement.DocElementCreationParserHandler;
import org.testingisdocumenting.znai.reference.DocReferences;
import org.testingisdocumenting.znai.search.SearchCrawlerParserHandler;
import znaishaded.org.jsoup.Jsoup;
import znaishaded.org.jsoup.nodes.Document;
import znaishaded.org.jsoup.nodes.Node;
import znaishaded.org.jsoup.nodes.TextNode;
import znaishaded.org.jsoup.select.NodeVisitor;

public class HtmlToDocElementConverter {
    private HtmlToDocElementConverter() {
    }

    public static Result convert(ComponentsRegistry componentsRegistry, Path filePath, String html, DocReferences codeReferences, boolean isMarkdown) {
        Document document = Jsoup.parse(html);
        document.outputSettings(new Document.OutputSettings().prettyPrint(false));
        SearchCrawlerParserHandler searchCrawler = new SearchCrawlerParserHandler();
        DocElementCreationParserHandler parserHandler = new DocElementCreationParserHandler(componentsRegistry, filePath);
        ParserHandlersList parserHandlersList = new ParserHandlersList(parserHandler, searchCrawler);
        document.body().traverse(new ConverterNodeVisitor(filePath, componentsRegistry.markdownParser(), parserHandlersList, codeReferences, isMarkdown));
        parserHandlersList.onParsingEnd();
        return new Result(parserHandler.getDocElement().getContent(), searchCrawler.getSearchEntries().stream().map(se -> se.getSearchText().getText()).collect(Collectors.joining(" ")));
    }

    private static class ConverterNodeVisitor
    implements NodeVisitor {
        private final Path filePath;
        private final MarkdownParser markdownParser;
        private final ParserHandler parserHandler;
        private final DocReferences codeReferences;
        private final boolean isMarkdown;
        private boolean isInsideInlinedCode;
        private boolean isInsideBlockCode;
        private boolean isInsideParagraph;

        ConverterNodeVisitor(Path filePath, MarkdownParser markdownParser, ParserHandler parserHandler, DocReferences codeReferences, boolean isMarkdown) {
            this.filePath = filePath;
            this.markdownParser = markdownParser;
            this.parserHandler = parserHandler;
            this.codeReferences = codeReferences;
            this.isMarkdown = isMarkdown;
            if (!isMarkdown) {
                this.startParagraphIfRequired();
            }
        }

        @Override
        public void head(Node node, int i) {
            if (ConverterNodeVisitor.isParagraph(node)) {
                this.closeParagraphIfRequired();
                this.startParagraph();
            } else if (ConverterNodeVisitor.isInlinedCode(node)) {
                this.isInsideInlinedCode = true;
            } else if (ConverterNodeVisitor.isBlockCode(node)) {
                this.isInsideBlockCode = true;
            } else if (ConverterNodeVisitor.isBold(node)) {
                this.parserHandler.onStrongEmphasisStart();
            } else if (ConverterNodeVisitor.isItalic(node)) {
                this.parserHandler.onEmphasisStart();
            } else if (ConverterNodeVisitor.isLink(node)) {
                this.parserHandler.onLinkStart(this.filePath, node.attr("href"));
            } else if (ConverterNodeVisitor.isUnorderedList(node)) {
                this.closeParagraphIfRequired();
                this.parserHandler.onBulletListStart('*', false);
            } else if (ConverterNodeVisitor.isOrderedList(node)) {
                this.closeParagraphIfRequired();
                this.parserHandler.onOrderedListStart('.', 1);
            } else if (ConverterNodeVisitor.isListItem(node)) {
                this.parserHandler.onListItemStart();
            } else if (node.nodeName().equals("#text")) {
                TextNode textNode = (TextNode)node;
                this.handleText(textNode);
            }
        }

        @Override
        public void tail(Node node, int i) {
            if (ConverterNodeVisitor.isParagraph(node)) {
                this.closeParagraphIfRequired();
            } else if (ConverterNodeVisitor.isInlinedCode(node)) {
                this.isInsideInlinedCode = false;
            } else if (ConverterNodeVisitor.isBlockCode(node)) {
                this.isInsideBlockCode = false;
            } else if (ConverterNodeVisitor.isBold(node)) {
                this.parserHandler.onStrongEmphasisEnd();
            } else if (ConverterNodeVisitor.isItalic(node)) {
                this.parserHandler.onEmphasisEnd();
            } else if (ConverterNodeVisitor.isLink(node)) {
                this.parserHandler.onLinkEnd();
            } else if (ConverterNodeVisitor.isUnorderedList(node)) {
                this.parserHandler.onBulletListEnd();
                this.closeParagraphIfRequired();
                this.startParagraph();
            } else if (ConverterNodeVisitor.isOrderedList(node)) {
                this.parserHandler.onOrderedListEnd();
                this.closeParagraphIfRequired();
                this.startParagraph();
            } else if (ConverterNodeVisitor.isListItem(node)) {
                this.parserHandler.onListItemEnd();
            }
        }

        private void handleText(TextNode textNode) {
            String content = textNode.text();
            if (content.trim().isEmpty()) {
                return;
            }
            if (this.isInsideInlinedCode) {
                this.parserHandler.onInlinedCode(content, this.codeReferences);
            } else if (this.isInsideBlockCode) {
                this.closeParagraphIfRequired();
                this.parserHandler.onSnippet(PluginParams.EMPTY, "", "", content);
            } else if (this.isMarkdown) {
                this.parseMarkdownText(textNode.getWholeText());
            } else {
                this.parserHandler.onSimpleText(content);
            }
        }

        private void parseMarkdownText(String text) {
            this.markdownParser.parse(this.filePath, this.parserHandler, text.trim());
        }

        private void startParagraphIfRequired() {
            if (this.isInsideParagraph) {
                return;
            }
            this.startParagraph();
        }

        private void startParagraph() {
            this.isInsideParagraph = true;
            this.parserHandler.onParagraphStart();
        }

        private void closeParagraphIfRequired() {
            if (this.isInsideParagraph) {
                this.parserHandler.onParagraphEnd();
                this.isInsideParagraph = false;
            }
        }

        private static boolean isParagraph(Node node) {
            return node.nodeName().equals("p");
        }

        private static boolean isBlockCode(Node node) {
            return node.nodeName().equals("pre");
        }

        private static boolean isUnorderedList(Node node) {
            return node.nodeName().equals("ul");
        }

        private static boolean isOrderedList(Node node) {
            return node.nodeName().equals("ol");
        }

        private static boolean isListItem(Node node) {
            return node.nodeName().equals("li");
        }

        private static boolean isBold(Node node) {
            return node.nodeName().equals("b");
        }

        private static boolean isItalic(Node node) {
            return node.nodeName().equals("i");
        }

        private static boolean isInlinedCode(Node node) {
            return node.nodeName().equals("code");
        }

        private static boolean isLink(Node node) {
            return node.nodeName().equals("a");
        }
    }

    public static class Result {
        private final List<DocElement> docElements;
        private final String searchText;

        public Result(List<DocElement> docElements, String searchText) {
            this.docElements = docElements;
            this.searchText = searchText;
        }

        public List<DocElement> getDocElements() {
            return this.docElements;
        }

        public String getSearchText() {
            return this.searchText;
        }
    }
}

