/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.openapi;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.openapi.OpenApi3Content;
import org.testingisdocumenting.znai.openapi.OpenApi3Operation;
import org.testingisdocumenting.znai.openapi.OpenApi3Parameter;
import org.testingisdocumenting.znai.openapi.OpenApi3Request;
import org.testingisdocumenting.znai.openapi.OpenApi3Response;
import org.testingisdocumenting.znai.openapi.OpenApi3Schema;
import org.testingisdocumenting.znai.utils.StringUtils;
import znaishaded.io.swagger.parser.OpenAPIParser;
import znaishaded.io.swagger.v3.oas.models.Operation;
import znaishaded.io.swagger.v3.oas.models.PathItem;
import znaishaded.io.swagger.v3.oas.models.Paths;
import znaishaded.io.swagger.v3.oas.models.media.Content;
import znaishaded.io.swagger.v3.oas.models.media.Schema;
import znaishaded.io.swagger.v3.oas.models.parameters.Parameter;
import znaishaded.io.swagger.v3.oas.models.parameters.RequestBody;
import znaishaded.io.swagger.v3.oas.models.responses.ApiResponses;
import znaishaded.io.swagger.v3.parser.core.models.ParseOptions;
import znaishaded.io.swagger.v3.parser.core.models.SwaggerParseResult;

public class OpenApi3Spec {
    private final String spec;
    private final SwaggerParseResult parseResult;
    private final List<OpenApi3Operation> operations;

    private OpenApi3Spec(String spec) {
        this.spec = spec;
        this.operations = new ArrayList<OpenApi3Operation>();
        OpenAPIParser parser = new OpenAPIParser();
        ParseOptions parseOptions = new ParseOptions();
        parseOptions.setResolve(true);
        parseOptions.setResolveFully(true);
        this.parseResult = parser.readContents(spec, null, parseOptions);
        this.process();
    }

    public static OpenApi3Spec parse(String spec) {
        return new OpenApi3Spec(spec);
    }

    public List<OpenApi3Operation> getOperations() {
        return this.operations;
    }

    public OpenApi3Operation findById(String id) {
        return this.operations.stream().filter(op -> id.equals(op.getId())).findFirst().orElse(null);
    }

    public OpenApi3Operation findByMethodAndPath(String method, String path) {
        return this.operations.stream().filter(o -> o.matches(method, path)).findFirst().orElseThrow(() -> new RuntimeException("cannot find operation: " + method + " " + path));
    }

    public List<OpenApi3Operation> findOperationsByTags(List<String> tags) {
        return this.operations.stream().filter(o -> o.hasTags(tags)).collect(Collectors.toList());
    }

    private void process() {
        Paths paths = this.parseResult.getOpenAPI().getPaths();
        for (Map.Entry pathEntry : paths.entrySet()) {
            String path = (String)pathEntry.getKey();
            PathItem pathItem = (PathItem)pathEntry.getValue();
            this.handleOperation(path, "GET", pathItem.getGet());
            this.handleOperation(path, "POST", pathItem.getPost());
            this.handleOperation(path, "PUT", pathItem.getPut());
            this.handleOperation(path, "DELETE", pathItem.getDelete());
            this.handleOperation(path, "PATCH", pathItem.getPatch());
        }
    }

    private void handleOperation(String path, String method, Operation parsed) {
        RequestBody requestBody;
        List<Parameter> parsedParameters;
        if (parsed == null) {
            return;
        }
        OpenApi3Operation operation = new OpenApi3Operation();
        operation.setId(Objects.toString(parsed.getOperationId()));
        operation.setPath(path);
        operation.setMethod(method);
        operation.setSummary(parsed.getSummary());
        operation.setDescription(parsed.getDescription());
        if (parsed.getTags() != null) {
            operation.addTags(parsed.getTags());
        }
        if ((parsedParameters = parsed.getParameters()) != null) {
            parsedParameters.forEach(parsedParameter -> operation.addParameter(OpenApi3Spec.convertParameter(parsedParameter)));
        }
        if ((requestBody = parsed.getRequestBody()) != null) {
            OpenApi3Request requests = new OpenApi3Request(requestBody.getDescription(), OpenApi3Spec.convertContent(requestBody.getContent()));
            operation.setRequest(requests);
        }
        ApiResponses parsedResponses = parsed.getResponses();
        parsedResponses.forEach((code, parsedResponse) -> {
            OpenApi3Response response = new OpenApi3Response((String)code, parsedResponse.getDescription(), OpenApi3Spec.convertContent(parsedResponse.getContent()));
            operation.addResponse(response);
        });
        this.operations.add(operation);
    }

    private static OpenApi3Parameter convertParameter(Parameter parsedParameter) {
        OpenApi3Parameter parameter = new OpenApi3Parameter();
        parameter.setName(parsedParameter.getName());
        parameter.setDescription(StringUtils.nullAsEmpty(parsedParameter.getDescription()));
        parameter.setIn(StringUtils.nullAsEmpty(parsedParameter.getIn()));
        parameter.setRequired(OpenApi3Spec.nullAsFalse(parsedParameter.getRequired()));
        parameter.setDeprecated(OpenApi3Spec.nullAsFalse(parsedParameter.getDeprecated()));
        parameter.setSchema(OpenApi3Spec.convertSchema(parsedParameter.getSchema()));
        return parameter;
    }

    private static OpenApi3Content convertContent(Content parsedContent) {
        if (parsedContent == null) {
            return new OpenApi3Content();
        }
        OpenApi3Content result = new OpenApi3Content();
        parsedContent.forEach((mimeType, media) -> result.register((String)mimeType, OpenApi3Spec.convertSchema(media.getSchema()), media.getExample()));
        return result;
    }

    private static OpenApi3Schema convertSchema(Schema<?> schema) {
        return OpenApi3Schema.convertFromParsed("", schema);
    }

    private static boolean nullAsFalse(Boolean value) {
        return value != null && value != false;
    }
}

