/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.parser.commonmark.include;

import java.util.regex.Pattern;
import org.testingisdocumenting.znai.extensions.PluginParamsFactory;
import org.testingisdocumenting.znai.extensions.PluginsRegexp;
import org.testingisdocumenting.znai.parser.commonmark.include.IncludeBlock;
import znaishaded.org.commonmark.internal.DocumentBlockParser;
import znaishaded.org.commonmark.internal.IndentedCodeBlockParser;
import znaishaded.org.commonmark.node.Block;
import znaishaded.org.commonmark.parser.InlineParser;
import znaishaded.org.commonmark.parser.block.AbstractBlockParser;
import znaishaded.org.commonmark.parser.block.AbstractBlockParserFactory;
import znaishaded.org.commonmark.parser.block.BlockContinue;
import znaishaded.org.commonmark.parser.block.BlockParser;
import znaishaded.org.commonmark.parser.block.BlockStart;
import znaishaded.org.commonmark.parser.block.MatchedBlockParser;
import znaishaded.org.commonmark.parser.block.ParserState;

public class IncludeBlockParser
extends AbstractBlockParser {
    private static final Pattern SPACES_REGEXP = Pattern.compile("^\\s{4,}.*$");
    private final StringBuilder value;
    private final PluginParamsFactory pluginParamsFactory;
    private final String pluginId;
    private final IncludeBlock block;

    IncludeBlockParser(PluginParamsFactory pluginParamsFactory, String pluginId, String value) {
        this.pluginParamsFactory = pluginParamsFactory;
        this.pluginId = pluginId;
        this.value = new StringBuilder();
        this.block = new IncludeBlock();
        this.value.append(value);
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public void closeBlock() {
        this.block.setParams(this.pluginParamsFactory.create(this.pluginId, this.value.toString()));
        super.closeBlock();
    }

    @Override
    public void addLine(CharSequence line) {
    }

    @Override
    public void parseInlines(InlineParser inlineParser) {
    }

    @Override
    public BlockContinue tryContinue(ParserState parserState) {
        CharSequence line = parserState.getLine();
        if (line.toString().trim().isEmpty() || PluginsRegexp.INCLUDE_PLUGIN_PATTERN.matcher(line).matches()) {
            return BlockContinue.none();
        }
        this.value.append(line);
        return BlockContinue.atIndex(parserState.getIndex());
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        private final PluginParamsFactory pluginParamsFactory;

        public Factory(PluginParamsFactory pluginParamsFactory) {
            this.pluginParamsFactory = pluginParamsFactory;
        }

        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            CharSequence line = state.getLine();
            BlockParser parentParser = matchedBlockParser.getMatchedBlockParser();
            if (parentParser instanceof DocumentBlockParser && SPACES_REGEXP.matcher(line).matches()) {
                return BlockStart.none();
            }
            if (parentParser instanceof IndentedCodeBlockParser) {
                return BlockStart.none();
            }
            PluginsRegexp.IdAndParams idAndParams = PluginsRegexp.parseIncludePlugin(line);
            if (idAndParams != null) {
                return BlockStart.of(new IncludeBlockParser(this.pluginParamsFactory, idAndParams.getId(), idAndParams.getParams())).atIndex(state.getIndex());
            }
            return BlockStart.none();
        }
    }
}

