/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.server.preview;

import java.nio.file.Path;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.console.ConsoleOutputs;
import org.testingisdocumenting.znai.console.ansi.Color;
import org.testingisdocumenting.znai.server.HttpServerUtils;
import org.testingisdocumenting.znai.server.NoAuthenticationHandler;
import org.testingisdocumenting.znai.server.ZnaiServer;
import org.testingisdocumenting.znai.server.preview.FileWatcher;
import org.testingisdocumenting.znai.server.preview.PreviewPushFileChangeHandler;
import org.testingisdocumenting.znai.server.preview.PreviewWebSocketHandler;
import org.testingisdocumenting.znai.server.sockets.WebSocketHandlers;
import org.testingisdocumenting.znai.website.WebSite;
import znaishaded.io.vertx.core.http.HttpServer;

public class DocumentationPreview {
    private final Path deployRoot;

    public DocumentationPreview(Path deployRoot) {
        this.deployRoot = deployRoot;
    }

    public void start(WebSite webSite, int port, Runnable onStart) {
        ZnaiServer znaiServer = new ZnaiServer(webSite.getReactJsBundle(), this.deployRoot, new NoAuthenticationHandler());
        PreviewWebSocketHandler previewWebSocketHandler = new PreviewWebSocketHandler();
        WebSocketHandlers.add(previewWebSocketHandler);
        HttpServer server = znaiServer.create();
        this.reportPhase("starting server");
        PreviewPushFileChangeHandler fileChangeHandler = new PreviewPushFileChangeHandler(previewWebSocketHandler, webSite);
        HttpServerUtils.listen(server, port);
        this.reportPhase("initializing file watcher");
        FileWatcher fileWatcher = new FileWatcher(webSite.getCfg(), Stream.concat(webSite.getAuxiliaryFilesRegistry().getAllPaths(), webSite.getToc().getResolvedPaths().stream()), fileChangeHandler);
        webSite.getAuxiliaryFilesRegistry().registerListener(fileWatcher);
        webSite.registerTocChangeListener(fileWatcher);
        onStart.run();
        fileWatcher.start();
    }

    private void reportPhase(String phase) {
        ConsoleOutputs.out(new Object[]{Color.BLUE, phase});
    }
}

