/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.structure;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class UniqueAnchorIdGenerator {
    private final Map<Path, List<LevelId>> headingsByPath = new ConcurrentHashMap<Path, List<LevelId>>();
    private final Map<Path, Map<String, Integer>> usedHeadingsCountByPath = new ConcurrentHashMap<Path, Map<String, Integer>>();

    public void registerSectionOrSubHeading(Path path, Integer level, String id) {
        List<LevelId> headings = this.getOrCreateHeadings(path);
        headings.removeIf(levelId -> levelId.level >= level);
        headings.add(new LevelId(level, id));
    }

    public String generateId(Path path, String nonUniqueId) {
        Map usedHeadingsCount;
        Integer count;
        List<LevelId> headings = this.getOrCreateHeadings(path);
        Object prefix = headings.stream().map(LevelId::getId).filter(id -> !id.isEmpty()).collect(Collectors.joining("-"));
        if (!nonUniqueId.isEmpty()) {
            prefix = (String)prefix + (String)(((String)prefix).isEmpty() ? nonUniqueId : "-" + nonUniqueId);
        }
        if ((count = (Integer)(usedHeadingsCount = this.usedHeadingsCountByPath.computeIfAbsent(path, k -> new HashMap())).get(prefix)) == null) {
            usedHeadingsCount.put(prefix, 1);
            return prefix;
        }
        usedHeadingsCount.put(prefix, count + 1);
        return (String)prefix + "-" + (count + 1);
    }

    private List<LevelId> getOrCreateHeadings(Path path) {
        return this.headingsByPath.computeIfAbsent(path, k -> new ArrayList());
    }

    public void resetCountersIfPresent(Path path) {
        this.headingsByPath.remove(path);
        this.usedHeadingsCountByPath.remove(path);
    }

    static class LevelId {
        private final Integer level;
        private final String id;

        public LevelId(Integer level, String id) {
            this.level = level;
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

