/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.draftv3;

import java.util.EnumSet;
import java.util.HashSet;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.github.fge.jackson.NodeType;
import znaishaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import znaishaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.SyntaxChecker;
import znaishaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.helpers.DependenciesSyntaxChecker;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import znaishaded.com.github.fge.jsonschema.core.tree.SchemaTree;
import znaishaded.com.github.fge.msgsimple.bundle.MessageBundle;
import znaishaded.com.google.common.base.Equivalence;
import znaishaded.com.google.common.collect.Sets;

public final class DraftV3DependenciesSyntaxChecker
extends DependenciesSyntaxChecker {
    private static final SyntaxChecker INSTANCE = new DraftV3DependenciesSyntaxChecker();

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    private DraftV3DependenciesSyntaxChecker() {
        super(NodeType.ARRAY, NodeType.STRING);
    }

    @Override
    protected void checkDependency(ProcessingReport report, MessageBundle bundle, String name, SchemaTree tree) throws ProcessingException {
        JsonNode node = this.getNode(tree).get(name);
        NodeType type = NodeType.getNodeType(node);
        if (type == NodeType.STRING) {
            return;
        }
        if (type != NodeType.ARRAY) {
            report.error(this.newMsg(tree, bundle, "common.dependencies.value.incorrectType").putArgument("property", name).putArgument("expected", this.dependencyTypes).putArgument("found", type));
            return;
        }
        int size = node.size();
        if (size == 0) {
            report.warn(this.newMsg(tree, bundle, "common.array.empty").put("property", name));
            return;
        }
        HashSet<Equivalence.Wrapper<JsonNode>> set = Sets.newHashSet();
        boolean uniqueElements = true;
        for (int index = 0; index < size; ++index) {
            JsonNode element = node.get(index);
            type = NodeType.getNodeType(element);
            uniqueElements = set.add(EQUIVALENCE.wrap(element));
            if (type == NodeType.STRING) continue;
            report.error(this.newMsg(tree, bundle, "common.array.element.incorrectType").put("property", name).putArgument("index", index).putArgument("expected", EnumSet.of(NodeType.STRING)).putArgument("found", type));
        }
        if (!uniqueElements) {
            report.warn(this.newMsg(tree, bundle, "common.array.duplicateElements").put("property", name));
        }
    }
}

