/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.core.processing;

import znaishaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import znaishaded.com.github.fge.jsonschema.core.messages.JsonSchemaCoreMessageBundle;
import znaishaded.com.github.fge.jsonschema.core.processing.Processor;
import znaishaded.com.github.fge.jsonschema.core.report.ListProcessingReport;
import znaishaded.com.github.fge.jsonschema.core.report.LogLevel;
import znaishaded.com.github.fge.jsonschema.core.report.MessageProvider;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import znaishaded.com.github.fge.msgsimple.bundle.MessageBundle;
import znaishaded.com.github.fge.msgsimple.load.MessageBundles;

public final class ProcessingResult<R extends MessageProvider> {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaCoreMessageBundle.class);
    private final ProcessingReport report;
    private final R result;

    private ProcessingResult(ProcessingReport report, R result) {
        BUNDLE.checkNotNull(report, "processing.nullReport");
        this.report = report;
        this.result = result;
    }

    public static <IN extends MessageProvider, OUT extends MessageProvider> ProcessingResult<OUT> of(Processor<IN, OUT> processor, ProcessingReport report, IN input) throws ProcessingException {
        BUNDLE.checkNotNull(processor, "processing.nullProcessor");
        OUT out = processor.process(report, input);
        return new ProcessingResult<OUT>(report, out);
    }

    public static <IN extends MessageProvider, OUT extends MessageProvider> ProcessingResult<OUT> uncheckedResult(Processor<IN, OUT> processor, ProcessingReport report, IN input) {
        try {
            return ProcessingResult.of(processor, report, input);
        }
        catch (ProcessingException e) {
            return new ProcessingResult<Object>(ProcessingResult.buildReport(report, e), null);
        }
    }

    public ProcessingReport getReport() {
        return this.report;
    }

    public R getResult() {
        return this.result;
    }

    public boolean isSuccess() {
        return this.report.isSuccess();
    }

    private static ProcessingReport buildReport(ProcessingReport report, ProcessingException e) {
        ListProcessingReport ret = new ListProcessingReport(LogLevel.DEBUG, LogLevel.NONE);
        try {
            ret.fatal(e.getProcessingMessage().put("info", BUNDLE.getMessage("processing.moreMessages")));
            ret.mergeWith(report);
        }
        catch (ProcessingException processingException) {
            // empty catch block
        }
        return ret;
    }
}

