/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.parser.processors;

import java.util.List;
import java.util.Map;
import znaishaded.io.swagger.models.ArrayModel;
import znaishaded.io.swagger.models.ComposedModel;
import znaishaded.io.swagger.models.Model;
import znaishaded.io.swagger.models.ModelImpl;
import znaishaded.io.swagger.models.RefModel;
import znaishaded.io.swagger.models.Swagger;
import znaishaded.io.swagger.models.properties.Property;
import znaishaded.io.swagger.models.refs.RefType;
import znaishaded.io.swagger.parser.ResolverCache;
import znaishaded.io.swagger.parser.processors.ExternalRefProcessor;
import znaishaded.io.swagger.parser.processors.PropertyProcessor;
import znaishaded.io.swagger.parser.util.RefUtils;

public class ModelProcessor {
    private final PropertyProcessor propertyProcessor;
    private final ExternalRefProcessor externalRefProcessor;

    public ModelProcessor(ResolverCache cache, Swagger swagger) {
        this.propertyProcessor = new PropertyProcessor(cache, swagger);
        this.externalRefProcessor = new ExternalRefProcessor(cache, swagger);
    }

    public void processModel(Model model) {
        if (model == null) {
            return;
        }
        if (model instanceof RefModel) {
            this.processRefModel((RefModel)model);
        } else if (model instanceof ArrayModel) {
            this.processArrayModel((ArrayModel)model);
        } else if (model instanceof ComposedModel) {
            this.processComposedModel((ComposedModel)model);
        } else if (model instanceof ModelImpl) {
            this.processModelImpl((ModelImpl)model);
        }
    }

    private void processModelImpl(ModelImpl modelImpl) {
        Map<String, Property> properties = modelImpl.getProperties();
        if (properties == null) {
            return;
        }
        for (Map.Entry<String, Property> propertyEntry : properties.entrySet()) {
            Property property = propertyEntry.getValue();
            this.propertyProcessor.processProperty(property);
        }
    }

    private void processComposedModel(ComposedModel composedModel) {
        this.processModel(composedModel.getParent());
        this.processModel(composedModel.getChild());
        List<RefModel> interfaces = composedModel.getInterfaces();
        if (interfaces != null) {
            for (RefModel model : interfaces) {
                this.processRefModel(model);
            }
        }
    }

    private void processArrayModel(ArrayModel arrayModel) {
        Property items = arrayModel.getItems();
        if (items != null) {
            this.propertyProcessor.processProperty(items);
        }
    }

    private void processRefModel(RefModel refModel) {
        String newRef = null;
        if (RefUtils.isAnExternalRefFormat(refModel.getRefFormat())) {
            newRef = this.externalRefProcessor.processRefToExternalDefinition(refModel.get$ref(), refModel.getRefFormat());
        }
        if (newRef != null) {
            refModel.set$ref(RefType.DEFINITION.getInternalPrefix() + newRef);
        }
    }
}

