/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.v3.parser.processors;

import java.util.Map;
import znaishaded.io.swagger.v3.oas.models.OpenAPI;
import znaishaded.io.swagger.v3.oas.models.examples.Example;
import znaishaded.io.swagger.v3.oas.models.headers.Header;
import znaishaded.io.swagger.v3.oas.models.media.Content;
import znaishaded.io.swagger.v3.oas.models.media.MediaType;
import znaishaded.io.swagger.v3.oas.models.media.Schema;
import znaishaded.io.swagger.v3.parser.ResolverCache;
import znaishaded.io.swagger.v3.parser.models.RefFormat;
import znaishaded.io.swagger.v3.parser.processors.ExampleProcessor;
import znaishaded.io.swagger.v3.parser.processors.ExternalRefProcessor;
import znaishaded.io.swagger.v3.parser.processors.SchemaProcessor;
import znaishaded.io.swagger.v3.parser.util.RefUtils;

public class HeaderProcessor {
    private final ResolverCache cache;
    private final SchemaProcessor schemaProcessor;
    private final ExampleProcessor exampleProcessor;
    private final ExternalRefProcessor externalRefProcessor;
    private final OpenAPI openAPI;

    public HeaderProcessor(ResolverCache cache, OpenAPI openAPI) {
        this(cache, openAPI, false);
    }

    public HeaderProcessor(ResolverCache cache, OpenAPI openAPI, boolean openapi31) {
        this.cache = cache;
        this.openAPI = openAPI;
        this.schemaProcessor = new SchemaProcessor(cache, openAPI, openapi31);
        this.exampleProcessor = new ExampleProcessor(cache, openAPI);
        this.externalRefProcessor = new ExternalRefProcessor(cache, openAPI);
    }

    public void processHeader(Header header) {
        if (header.get$ref() != null) {
            String newRef;
            RefFormat refFormat = RefUtils.computeRefFormat(header.get$ref());
            String $ref = header.get$ref();
            if (RefUtils.isAnExternalRefFormat(refFormat) && (newRef = this.externalRefProcessor.processRefToExternalHeader($ref, refFormat)) != null) {
                header.set$ref(newRef);
            }
        }
        if (header.getSchema() != null) {
            this.schemaProcessor.processSchema(header.getSchema());
        }
        if (header.getExamples() != null && header.getExamples() != null) {
            Map<String, Example> examples = header.getExamples();
            for (String key : examples.keySet()) {
                this.exampleProcessor.processExample(header.getExamples().get(key));
            }
        }
        Schema schema = null;
        if (header.getContent() != null) {
            Content content = header.getContent();
            for (String mediaName : content.keySet()) {
                MediaType mediaType = (MediaType)content.get(mediaName);
                if (mediaType.getSchema() == null || (schema = mediaType.getSchema()) == null) continue;
                this.schemaProcessor.processSchema(schema);
            }
        }
    }
}

