/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.web.handler.sockjs.impl;

import java.util.UUID;
import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.Vertx;
import znaishaded.io.vertx.core.buffer.Buffer;
import znaishaded.io.vertx.core.eventbus.Message;
import znaishaded.io.vertx.core.eventbus.MessageConsumer;
import znaishaded.io.vertx.ext.auth.User;
import znaishaded.io.vertx.ext.web.Session;
import znaishaded.io.vertx.ext.web.handler.sockjs.SockJSSocket;

public abstract class SockJSSocketBase
implements SockJSSocket {
    private final MessageConsumer<Buffer> registration;
    protected final Vertx vertx;
    protected Session webSession;
    protected User webUser;
    private final String writeHandlerID;

    @Override
    public abstract SockJSSocket exceptionHandler(Handler<Throwable> var1);

    protected SockJSSocketBase(Vertx vertx, Session webSession, User webUser) {
        this.vertx = vertx;
        this.webSession = webSession;
        this.webUser = webUser;
        Handler<Message> writeHandler = buff -> this.write((Buffer)buff.body());
        this.writeHandlerID = UUID.randomUUID().toString();
        this.registration = vertx.eventBus().consumer(this.writeHandlerID).handler(writeHandler);
    }

    @Override
    public String writeHandlerID() {
        return this.writeHandlerID;
    }

    @Override
    public void end() {
        this.registration.unregister();
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.registration.unregister(handler);
    }

    @Override
    public void close() {
        this.end();
    }

    public void closeAfterSessionExpired() {
        this.close();
    }

    @Override
    public Session webSession() {
        return this.webSession;
    }

    @Override
    public User webUser() {
        return this.webUser;
    }
}

