/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.OptionFlags;
import znaishaded.net.sourceforge.plantuml.OptionPrint;
import znaishaded.net.sourceforge.plantuml.Scale;
import znaishaded.net.sourceforge.plantuml.command.BlocLines;
import znaishaded.net.sourceforge.plantuml.command.Command;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.ProtectedCommand;
import znaishaded.net.sourceforge.plantuml.core.Diagram;
import znaishaded.net.sourceforge.plantuml.core.ImageData;
import znaishaded.net.sourceforge.plantuml.core.UmlSource;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.DisplayPositioned;
import znaishaded.net.sourceforge.plantuml.cucadiagram.DisplayPositionned;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.VerticalAlignment;
import znaishaded.net.sourceforge.plantuml.stats.StatsUtilsIncrement;
import znaishaded.net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import znaishaded.net.sourceforge.plantuml.ugraphic.ImageBuilder;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;
import znaishaded.net.sourceforge.plantuml.version.License;
import znaishaded.net.sourceforge.plantuml.version.Version;

public abstract class AbstractPSystem
implements Diagram {
    private final UmlSource source;
    private Scale scale;
    private int splitPagesHorizontal = 1;
    private int splitPagesVertical = 1;

    public AbstractPSystem(UmlSource source) {
        this.source = Objects.requireNonNull(source);
    }

    private String getVersion() {
        StringBuilder toAppend = new StringBuilder();
        toAppend.append("PlantUML version ");
        toAppend.append(Version.versionString());
        toAppend.append("(" + Version.compileTimeString() + ")\n");
        toAppend.append("(" + (Object)((Object)License.getCurrent()) + " source distribution)\n");
        for (String name : OptionPrint.interestingProperties()) {
            toAppend.append(name);
            toAppend.append('\n');
        }
        return toAppend.toString();
    }

    @Override
    public final String getMetadata() {
        if (this.source == null) {
            return this.getVersion();
        }
        String rawString = this.source.getRawString();
        String plainString = this.source.getPlainString();
        if (rawString != null && rawString.equals(plainString)) {
            return rawString + "\n" + this.getVersion();
        }
        return rawString + "\n" + plainString + "\n" + this.getVersion();
    }

    @Override
    public final UmlSource getSource() {
        return this.source;
    }

    public final long seed() {
        if (this.source == null) {
            return 42L;
        }
        return this.getSource().seed();
    }

    @Override
    public int getNbImages() {
        return 1;
    }

    @Override
    public int getSplitPagesHorizontal() {
        return this.splitPagesHorizontal;
    }

    public void setSplitPagesHorizontal(int splitPagesHorizontal) {
        this.splitPagesHorizontal = splitPagesHorizontal;
    }

    @Override
    public int getSplitPagesVertical() {
        return this.splitPagesVertical;
    }

    public void setSplitPagesVertical(int splitPagesVertical) {
        this.splitPagesVertical = splitPagesVertical;
    }

    public DisplayPositionned getTitle() {
        if (this.source == null) {
            return DisplayPositioned.single(Display.empty(), HorizontalAlignment.CENTER, VerticalAlignment.TOP);
        }
        return DisplayPositioned.single(this.source.getTitle(), HorizontalAlignment.CENTER, VerticalAlignment.TOP);
    }

    @Override
    public String getWarningOrError() {
        return null;
    }

    public String checkFinalError() {
        return null;
    }

    public void makeDiagramReady() {
    }

    public boolean isOk() {
        return true;
    }

    public CommandExecutionResult executeCommand(Command cmd, BlocLines lines) {
        cmd = new ProtectedCommand(cmd);
        try {
            return cmd.execute(this, lines);
        }
        catch (NoSuchColorException e) {
            return CommandExecutionResult.badColor();
        }
    }

    @Override
    public boolean hasUrl() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ImageData exportDiagram(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        long now = System.currentTimeMillis();
        try {
            ImageData imageData = this.exportDiagramNow(os, index, fileFormatOption);
            return imageData;
        }
        finally {
            if (OptionFlags.getInstance().isEnableStats()) {
                StatsUtilsIncrement.onceMoreGenerate(System.currentTimeMillis() - now, this.getClass(), fileFormatOption.getFileFormat());
            }
        }
    }

    public final void setScale(Scale scale) {
        this.scale = scale;
    }

    public final Scale getScale() {
        return this.scale;
    }

    public ImageBuilder createImageBuilder(FileFormatOption fileFormatOption) throws IOException {
        return ImageBuilder.imageBuilder(fileFormatOption);
    }

    protected abstract ImageData exportDiagramNow(OutputStream var1, int var2, FileFormatOption var3) throws IOException;

    public ClockwiseTopRightBottomLeft getDefaultMargins() {
        return ClockwiseTopRightBottomLeft.same(0.0);
    }

    @Override
    public Display getTitleDisplay() {
        return null;
    }
}

