/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.FileFormat;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.FileGroup;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.OptionFlags;
import znaishaded.net.sourceforge.plantuml.OptionPreprocOutputMode;
import znaishaded.net.sourceforge.plantuml.OptionPrint;
import znaishaded.net.sourceforge.plantuml.Stdrpt;
import znaishaded.net.sourceforge.plantuml.StdrptNull;
import znaishaded.net.sourceforge.plantuml.StdrptPipe0;
import znaishaded.net.sourceforge.plantuml.StdrptV1;
import znaishaded.net.sourceforge.plantuml.StdrptV2;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import znaishaded.net.sourceforge.plantuml.preproc.Defines;
import znaishaded.net.sourceforge.plantuml.security.SFile;
import znaishaded.net.sourceforge.plantuml.stats.StatsUtils;

public class Option {
    private final List<String> excludes = new ArrayList<String>();
    private final List<String> config = new ArrayList<String>();
    private final Map<String, String> defines = new LinkedHashMap<String, String>();
    private String charset;
    private boolean computeurl = false;
    private boolean decodeurl = false;
    private boolean pipe = false;
    private String pipeDelimitor;
    private boolean pipeMap = false;
    private boolean pipeNoStdErr = false;
    private boolean syntax = false;
    private boolean checkOnly = false;
    private OptionPreprocOutputMode preprocessorOutput = null;
    private boolean failfast = false;
    private boolean failfast2 = false;
    private boolean noerror = false;
    private boolean duration = false;
    private boolean debugsvek = false;
    private boolean splash = false;
    private boolean textProgressBar = false;
    private int nbThreads = 0;
    private int ftpPort = -1;
    private String picowebBindAddress = null;
    private int picowebPort = -1;
    private boolean hideMetadata = false;
    private boolean checkMetadata = false;
    private int stdrpt = 0;
    private int imageIndex = 0;
    private String fileDir;
    private File outputDir = null;
    private File outputFile = null;
    private String filename;
    private final List<String> result = new ArrayList<String>();
    private FileFormatOption fileFormatOption = new FileFormatOption(FileFormat.PNG);

    public Option() {
    }

    @Deprecated
    public final void setFileFormat(FileFormat fileFormat) {
        this.setFileFormatOption(new FileFormatOption(fileFormat));
    }

    public final void setFileFormatOption(FileFormatOption newFormat) {
        this.fileFormatOption = newFormat;
    }

    public Option(String ... arg) throws InterruptedException, IOException {
        if (arg.length == 0) {
            OptionFlags.getInstance().setGui(true);
        }
        this.initInclude(GraphvizUtils.getenvDefaultConfigFilename());
        for (int i = 0; i < arg.length; ++i) {
            String s2 = arg[i];
            if (s2.equalsIgnoreCase("-headless")) {
                if (i != 0) {
                    Log.error("Warning: -headless flag must be the first one in the command line");
                }
                System.setProperty("java.awt.headless", "true");
                continue;
            }
            if (s2.equalsIgnoreCase("-tsvg") || s2.equalsIgnoreCase("-svg")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.SVG));
                continue;
            }
            if (s2.equalsIgnoreCase("-tsvg:nornd") || s2.equalsIgnoreCase("-svg:nornd")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.SVG));
                continue;
            }
            if (s2.equalsIgnoreCase("-thtml") || s2.equalsIgnoreCase("-html")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.HTML));
                continue;
            }
            if (s2.equalsIgnoreCase("-tscxml") || s2.equalsIgnoreCase("-scxml")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.SCXML));
                continue;
            }
            if (s2.equalsIgnoreCase("-txmi") || s2.equalsIgnoreCase("-xmi")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.XMI_STANDARD));
                continue;
            }
            if (s2.equalsIgnoreCase("-txmi:argo") || s2.equalsIgnoreCase("-xmi:argo")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.XMI_ARGO));
                continue;
            }
            if (s2.equalsIgnoreCase("-txmi:star") || s2.equalsIgnoreCase("-xmi:star")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.XMI_STAR));
                continue;
            }
            if (s2.equalsIgnoreCase("-teps") || s2.equalsIgnoreCase("-eps")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.EPS));
                continue;
            }
            if (s2.equalsIgnoreCase("-teps:text") || s2.equalsIgnoreCase("-eps:text")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.EPS_TEXT));
                continue;
            }
            if (s2.equalsIgnoreCase("-ttxt") || s2.equalsIgnoreCase("-txt")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.ATXT));
                continue;
            }
            if (s2.equalsIgnoreCase("-tutxt") || s2.equalsIgnoreCase("-utxt")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.UTXT));
                continue;
            }
            if (s2.equalsIgnoreCase("-braille") || s2.equalsIgnoreCase("-tbraille")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.BRAILLE_PNG));
                continue;
            }
            if (s2.equalsIgnoreCase("-png") || s2.equalsIgnoreCase("-tpng")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.PNG));
                continue;
            }
            if (s2.equalsIgnoreCase("-vdx") || s2.equalsIgnoreCase("-tvdx")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.VDX));
                continue;
            }
            if (s2.equalsIgnoreCase("-latex") || s2.equalsIgnoreCase("-tlatex")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.LATEX));
                continue;
            }
            if (s2.equalsIgnoreCase("-latex:nopreamble") || s2.equalsIgnoreCase("-tlatex:nopreamble")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.LATEX_NO_PREAMBLE));
                continue;
            }
            if (s2.equalsIgnoreCase("-base64") || s2.equalsIgnoreCase("-tbase64")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.BASE64));
                continue;
            }
            if (s2.equalsIgnoreCase("-pdf") || s2.equalsIgnoreCase("-tpdf")) {
                this.setFileFormatOption(new FileFormatOption(FileFormat.PDF));
                continue;
            }
            if (s2.equalsIgnoreCase("-overwrite")) {
                OptionFlags.getInstance().setOverwrite(true);
                continue;
            }
            if (s2.equalsIgnoreCase("-output") || s2.equalsIgnoreCase("-o")) {
                if (++i == arg.length) continue;
                this.outputDir = new File(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg[i]));
                continue;
            }
            if (s2.equalsIgnoreCase("-ofile")) {
                if (++i == arg.length) continue;
                this.outputFile = new File(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg[i]));
                continue;
            }
            if (s2.equalsIgnoreCase("-graphvizdot") || s2.equalsIgnoreCase("-graphviz_dot")) {
                if (++i == arg.length) continue;
                GraphvizUtils.setDotExecutable(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg[i]));
                continue;
            }
            if (s2.equalsIgnoreCase("-charset")) {
                if (++i == arg.length) continue;
                this.charset = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg[i]);
                continue;
            }
            if (s2.equalsIgnoreCase("-filename")) {
                if (++i == arg.length) continue;
                this.filename = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg[i]);
                continue;
            }
            if (s2.equalsIgnoreCase("-filedir")) {
                if (++i == arg.length) continue;
                this.fileDir = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg[i]);
                continue;
            }
            if (s2.startsWith("-o") && s2.length() > 3) {
                s2 = s2.substring(2);
                this.outputDir = new File(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(s2));
                continue;
            }
            if (s2.equalsIgnoreCase("-exclude") || s2.equalsIgnoreCase("-x")) {
                if (++i == arg.length) continue;
                this.excludes.add(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg[i]));
                continue;
            }
            if (s2.equalsIgnoreCase("-nbthread") || s2.equalsIgnoreCase("-nbthreads")) {
                if (++i == arg.length) continue;
                String nb = arg[i];
                if ("auto".equalsIgnoreCase(nb)) {
                    this.nbThreads = Option.defaultNbThreads();
                    continue;
                }
                if (!nb.matches("\\d+")) continue;
                this.nbThreads = Integer.parseInt(nb);
                continue;
            }
            if (s2.equalsIgnoreCase("-timeout")) {
                String timeSeconds;
                if (++i == arg.length || !(timeSeconds = arg[i]).matches("\\d+")) continue;
                OptionFlags.getInstance().setTimeoutMs((long)Integer.parseInt(timeSeconds) * 1000L);
                continue;
            }
            if (s2.equalsIgnoreCase("-failfast")) {
                this.failfast = true;
                continue;
            }
            if (s2.equalsIgnoreCase("-failfast2")) {
                this.failfast2 = true;
                continue;
            }
            if (s2.equalsIgnoreCase("-noerror")) {
                this.noerror = true;
                continue;
            }
            if (s2.equalsIgnoreCase("-checkonly")) {
                this.checkOnly = true;
                continue;
            }
            if (s2.equalsIgnoreCase("-theme")) {
                if (++i == arg.length) continue;
                this.config.add(0, "!theme " + arg[i]);
                continue;
            }
            if (s2.equalsIgnoreCase("-config")) {
                if (++i == arg.length) continue;
                this.initConfig(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg[i]));
                continue;
            }
            if (s2.startsWith("-I")) {
                this.initInclude(s2.substring(2));
                continue;
            }
            if (s2.equalsIgnoreCase("-computeurl") || s2.equalsIgnoreCase("-encodeurl")) {
                this.computeurl = true;
                continue;
            }
            if (s2.startsWith("-x")) {
                s2 = s2.substring(2);
                this.excludes.add(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(s2));
                continue;
            }
            if (s2.equalsIgnoreCase("-verbose") || s2.equalsIgnoreCase("-v")) {
                OptionFlags.getInstance().setVerbose(true);
                continue;
            }
            if (s2.equalsIgnoreCase("-pipe") || s2.equalsIgnoreCase("-p")) {
                this.pipe = true;
                continue;
            }
            if (s2.equalsIgnoreCase("-pipedelimitor")) {
                if (++i == arg.length) continue;
                this.pipeDelimitor = arg[i];
                continue;
            }
            if (s2.equalsIgnoreCase("-pipemap")) {
                this.pipeMap = true;
                continue;
            }
            if (s2.equalsIgnoreCase("-pipenostderr")) {
                this.pipeNoStdErr = true;
                continue;
            }
            if (s2.equalsIgnoreCase("-syntax")) {
                this.syntax = true;
                OptionFlags.getInstance().setQuiet(true);
                continue;
            }
            if (s2.equalsIgnoreCase("-duration")) {
                this.duration = true;
                continue;
            }
            if (s2.equalsIgnoreCase("-debugsvek") || s2.equalsIgnoreCase("-debug_svek")) {
                this.debugsvek = true;
                continue;
            }
            if (s2.equalsIgnoreCase("-keepfiles") || s2.equalsIgnoreCase("-keepfile")) {
                System.err.println("-keepfiles option has been removed. Please consider -debugsvek instead");
                continue;
            }
            if (s2.equalsIgnoreCase("-metadata")) {
                OptionFlags.getInstance().setExtractFromMetadata(true);
                continue;
            }
            if (s2.equalsIgnoreCase("-logdata")) {
                if (++i == arg.length) continue;
                OptionFlags.getInstance().setLogData(new SFile(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg[i])));
                continue;
            }
            if (s2.equalsIgnoreCase("-word")) {
                OptionFlags.getInstance().setWord(true);
                OptionFlags.getInstance().setQuiet(true);
                this.charset = "UTF-8";
                continue;
            }
            if (s2.equalsIgnoreCase("-quiet")) {
                OptionFlags.getInstance().setQuiet(true);
                continue;
            }
            if (s2.equalsIgnoreCase("-decodeurl")) {
                this.decodeurl = true;
                continue;
            }
            if (s2.equalsIgnoreCase("-version")) {
                OptionPrint.printVersion();
                continue;
            }
            if (s2.matches("(?i)^-li[sc][ea]n[sc]e\\s*$")) {
                OptionPrint.printLicense();
                continue;
            }
            if (s2.startsWith("-DPLANTUML_LIMIT_SIZE=")) {
                String v = s2.substring("-DPLANTUML_LIMIT_SIZE=".length());
                if (!v.matches("\\d+")) continue;
                System.setProperty("PLANTUML_LIMIT_SIZE", v);
                continue;
            }
            if (s2.startsWith("-D")) {
                this.manageDefine(s2.substring(2));
                continue;
            }
            if (s2.startsWith("-S")) {
                this.manageSkinParam(s2.substring(2));
                continue;
            }
            if (s2.startsWith("-P")) {
                this.managePragma(s2.substring(2));
                continue;
            }
            if (s2.equalsIgnoreCase("-testdot")) {
                OptionPrint.printTestDot();
                continue;
            }
            if (s2.equalsIgnoreCase("-about") || s2.equalsIgnoreCase("-author") || s2.equalsIgnoreCase("-authors")) {
                OptionPrint.printAbout();
                continue;
            }
            if (s2.equalsIgnoreCase("-help") || s2.equalsIgnoreCase("-h") || s2.equalsIgnoreCase("-?")) {
                OptionPrint.printHelp();
                continue;
            }
            if (s2.equalsIgnoreCase("-language")) {
                OptionPrint.printLanguage();
                continue;
            }
            if (s2.equalsIgnoreCase("-gui")) {
                OptionFlags.getInstance().setGui(true);
                continue;
            }
            if (s2.equalsIgnoreCase("-encodesprite")) {
                OptionFlags.getInstance().setEncodesprite(true);
                continue;
            }
            if (s2.equalsIgnoreCase("-printfonts")) {
                OptionFlags.getInstance().setPrintFonts(true);
                continue;
            }
            if (s2.equalsIgnoreCase("-dumphtmlstats")) {
                OptionFlags.getInstance().setDumpHtmlStats(true);
                continue;
            }
            if (s2.equalsIgnoreCase("-dumpstats")) {
                OptionFlags.getInstance().setDumpStats(true);
                continue;
            }
            if (s2.equalsIgnoreCase("-loopstats")) {
                OptionFlags.getInstance().setLoopStats(true);
                continue;
            }
            if (s2.equalsIgnoreCase("-enablestats")) {
                OptionFlags.getInstance().setEnableStats(true);
                continue;
            }
            if (s2.equalsIgnoreCase("-disablestats")) {
                OptionFlags.getInstance().setEnableStats(false);
                continue;
            }
            if (s2.equalsIgnoreCase("-extractstdlib")) {
                OptionFlags.getInstance().setExtractStdLib(true);
                continue;
            }
            if (s2.equalsIgnoreCase("-stdlib")) {
                OptionFlags.getInstance().setStdLib(true);
                continue;
            }
            if (s2.equalsIgnoreCase("-clipboard")) {
                OptionFlags.getInstance().setClipboard(true);
                continue;
            }
            if (s2.equalsIgnoreCase("-clipboardloop")) {
                OptionFlags.getInstance().setClipboardLoop(true);
                continue;
            }
            if (s2.equalsIgnoreCase("-htmlstats")) {
                StatsUtils.setHtmlStats(true);
                continue;
            }
            if (s2.equalsIgnoreCase("-xmlstats")) {
                StatsUtils.setXmlStats(true);
                continue;
            }
            if (s2.equalsIgnoreCase("-realtimestats")) {
                StatsUtils.setRealTimeStats(true);
                continue;
            }
            if (s2.equalsIgnoreCase("-useseparatorminus")) {
                OptionFlags.getInstance().setFileSeparator("-");
                continue;
            }
            if (s2.equalsIgnoreCase("-splash")) {
                this.splash = true;
                continue;
            }
            if (s2.equalsIgnoreCase("-progress")) {
                this.textProgressBar = true;
                continue;
            }
            if (s2.equalsIgnoreCase("-nometadata")) {
                this.hideMetadata = true;
                continue;
            }
            if (s2.equalsIgnoreCase("-preproc")) {
                this.preprocessorOutput = OptionPreprocOutputMode.NORMAL;
                continue;
            }
            if (s2.equalsIgnoreCase("-cypher")) {
                this.preprocessorOutput = OptionPreprocOutputMode.CYPHER;
                continue;
            }
            if (s2.equalsIgnoreCase("-checkmetadata")) {
                this.checkMetadata = true;
                continue;
            }
            if (s2.equalsIgnoreCase("-stdrpt:1")) {
                this.stdrpt = 1;
                continue;
            }
            if (s2.equalsIgnoreCase("-stdrpt:2")) {
                this.stdrpt = 2;
                continue;
            }
            if (s2.equalsIgnoreCase("-stdrpt")) {
                this.stdrpt = 2;
                continue;
            }
            if (s2.equalsIgnoreCase("-pipeimageindex")) {
                String nb;
                if (++i == arg.length || !(nb = arg[i]).matches("\\d+")) continue;
                this.imageIndex = Integer.parseInt(nb);
                continue;
            }
            if (StringUtils.goLowerCase(s2).startsWith("-ftp")) {
                int x = s2.indexOf(58);
                if (x == -1) {
                    this.ftpPort = 4242;
                    continue;
                }
                this.ftpPort = Integer.parseInt(s2.substring(x + 1));
                continue;
            }
            if (StringUtils.goLowerCase(s2).startsWith("-picoweb")) {
                String[] parts = s2.split(":");
                this.picowebPort = parts.length > 1 ? Integer.parseInt(parts[1]) : 8080;
                this.picowebBindAddress = parts.length > 2 ? parts[2] : null;
                continue;
            }
            if (s2.startsWith("-c")) {
                s2 = s2.substring(2);
                this.config.add(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(s2));
                continue;
            }
            this.result.add(s2);
        }
    }

    public Stdrpt getStdrpt() {
        if (this.stdrpt == 1) {
            return new StdrptV1();
        }
        if (this.stdrpt == 2) {
            return new StdrptV2();
        }
        if (this.isPipe() || this.isPipeMap() || this.isSyntax()) {
            return new StdrptPipe0();
        }
        return new StdrptNull();
    }

    public int getFtpPort() {
        return this.ftpPort;
    }

    public String getPicowebBindAddress() {
        return this.picowebBindAddress;
    }

    public int getPicowebPort() {
        return this.picowebPort;
    }

    private void addInConfig(BufferedReader br) throws IOException {
        if (br == null) {
            return;
        }
        try {
            String s2 = null;
            while ((s2 = br.readLine()) != null) {
                this.config.add(s2);
            }
        }
        finally {
            br.close();
        }
    }

    public void initConfig(String filename) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(filename));
        this.addInConfig(br);
    }

    private void initInclude(String filename) throws IOException {
        if (filename == null) {
            return;
        }
        if (filename.contains("*")) {
            FileGroup group = new FileGroup(filename, Collections.emptyList(), null);
            for (File f : group.getFiles()) {
                if (!f.exists() || !f.canRead()) continue;
                this.addInConfig(new BufferedReader(new FileReader(f)));
            }
        } else {
            File f = new File(filename);
            if (f.exists() && f.canRead()) {
                this.addInConfig(new BufferedReader(new FileReader(f)));
            }
        }
    }

    private void manageDefine(String s2) {
        Pattern2 p = MyPattern.cmpile("^(\\w+)(?:=(.*))?$");
        Matcher2 m3 = p.matcher(s2);
        if (m3.find()) {
            this.define(m3.group(1), m3.group(2));
        }
    }

    private void managePragma(String s2) {
        Pattern2 p = MyPattern.cmpile("^(\\w+)(?:=(.*))?$");
        Matcher2 m3 = p.matcher(s2);
        if (m3.find()) {
            String var = m3.group(1);
            String value = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(m3.group(2));
            if (var != null && value != null) {
                this.config.add("!pragma " + var + " " + value);
            }
        }
    }

    private void manageSkinParam(String s2) {
        Pattern2 p = MyPattern.cmpile("^(\\w+)(?:=(.*))?$");
        Matcher2 m3 = p.matcher(s2);
        if (m3.find()) {
            String var = m3.group(1);
            String value = m3.group(2);
            if (var != null && value != null) {
                this.config.add("skinparamlocked " + var + " " + value);
            }
        }
    }

    public final File getOutputDir() {
        return this.outputDir;
    }

    public static final String getPattern() {
        return "(?i)^.*\\.(txt|tex|java|htm|html|c|h|cpp|apt|pu|puml|hpp|hh)$";
    }

    public void setOutputDir(File f) {
        this.outputDir = f;
    }

    public final List<String> getExcludes() {
        return Collections.unmodifiableList(this.excludes);
    }

    public Defines getDefaultDefines(SFile f) {
        Defines result = Defines.createWithFileName(f);
        for (Map.Entry<String, String> ent : this.defines.entrySet()) {
            String value = ent.getValue();
            if (value == null) {
                value = "";
            }
            result.define(ent.getKey(), Arrays.asList(value), false, null);
        }
        return result;
    }

    public Defines getDefaultDefines(File f) {
        Defines result = Defines.createWithFileName(f);
        for (Map.Entry<String, String> ent : this.defines.entrySet()) {
            String value = ent.getValue();
            if (value == null) {
                value = "";
            }
            result.define(ent.getKey(), Arrays.asList(value), false, null);
        }
        return result;
    }

    public Defines getDefaultDefines() {
        Defines result = Defines.createEmpty();
        result.overrideFilename(this.filename);
        for (Map.Entry<String, String> ent : this.defines.entrySet()) {
            result.define(ent.getKey(), Arrays.asList(ent.getValue()), false, null);
        }
        return result;
    }

    public void define(String name, String value) {
        this.defines.put(name, value);
    }

    public List<String> getConfig() {
        return Collections.unmodifiableList(this.config);
    }

    public final List<String> getResult() {
        return Collections.unmodifiableList(this.result);
    }

    public final String getCharset() {
        return this.charset;
    }

    public void setCharset(String s2) {
        this.charset = s2;
    }

    public final boolean isComputeurl() {
        return this.computeurl;
    }

    public final boolean isDecodeurl() {
        return this.decodeurl;
    }

    public final boolean isPipe() {
        return this.pipe;
    }

    public final boolean isPipeMap() {
        return this.pipeMap;
    }

    public final boolean isSyntax() {
        return this.syntax;
    }

    public FileFormatOption getFileFormatOption() {
        if (this.debugsvek) {
            this.fileFormatOption.setDebugSvek(true);
        }
        if (this.hideMetadata) {
            this.fileFormatOption.hideMetadata();
        }
        return this.fileFormatOption;
    }

    public final boolean isDuration() {
        return this.duration;
    }

    public final int getNbThreads() {
        return this.nbThreads;
    }

    public final void setNbThreads(int nb) {
        this.nbThreads = nb;
    }

    public static int defaultNbThreads() {
        return Runtime.getRuntime().availableProcessors();
    }

    public final boolean isCheckOnly() {
        return this.checkOnly;
    }

    public final void setCheckOnly(boolean checkOnly) {
        this.checkOnly = checkOnly;
    }

    public final boolean isFailfastOrFailfast2() {
        return this.failfast || this.failfast2;
    }

    public final boolean isFailfast2() {
        return this.failfast2;
    }

    public final void setFailfast(boolean failfast) {
        this.failfast = failfast;
    }

    public final void setFailfast2(boolean failfast2) {
        this.failfast2 = failfast2;
    }

    public final void setNoerror(boolean noerror) {
        this.noerror = noerror;
    }

    public final boolean isNoerror() {
        return this.noerror;
    }

    public final File getOutputFile() {
        return this.outputFile;
    }

    public final void setDebugSvek(boolean debugsvek) {
        this.debugsvek = debugsvek;
    }

    boolean isDebugSvek() {
        return this.debugsvek;
    }

    public final boolean isSplash() {
        return this.splash;
    }

    public final void setSplash(boolean splash) {
        this.splash = splash;
    }

    public final boolean isTextProgressBar() {
        return this.textProgressBar;
    }

    public String getPipeDelimitor() {
        return this.pipeDelimitor;
    }

    public final boolean isPipeNoStdErr() {
        return this.pipeNoStdErr;
    }

    public final int getImageIndex() {
        return this.imageIndex;
    }

    public final void setFilename(String filename) {
        this.filename = filename;
    }

    public final boolean isCheckMetadata() {
        return this.checkMetadata;
    }

    public final OptionPreprocOutputMode getPreprocessorOutputMode() {
        return this.preprocessorOutput;
    }

    public String getFileDir() {
        return this.fileDir;
    }
}

