/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.LineBreakStrategy;
import znaishaded.net.sourceforge.plantuml.SkinParamColors;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.creole.Parser;
import znaishaded.net.sourceforge.plantuml.creole.Sheet;
import znaishaded.net.sourceforge.plantuml.creole.SheetBlock1;
import znaishaded.net.sourceforge.plantuml.creole.SheetBlock2;
import znaishaded.net.sourceforge.plantuml.creole.Stencil;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.Rainbow;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.UDrawable;
import znaishaded.net.sourceforge.plantuml.graphic.color.Colors;
import znaishaded.net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorNone;

public class FtileBox
extends AbstractFtile {
    private final ClockwiseTopRightBottomLeft padding;
    private final ClockwiseTopRightBottomLeft margin;
    private final TextBlock tb;
    private double roundCorner = 25.0;
    private final double shadowing;
    private final HorizontalAlignment horizontalAlignment;
    private double minimumWidth = 0.0;
    private final LinkRendering inRendering;
    private final Swimlane swimlane;
    private final BoxStyle boxStyle;
    private final HColor borderColor;
    private final HColor backColor;
    private final Style style;
    private final String print;

    public static StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.activity);
    }

    public static StyleSignatureBasic getStyleSignatureArrow() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.arrow);
    }

    @Override
    public final LinkRendering getInLinkRendering() {
        return this.inRendering;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.swimlane == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    public static FtileBox create(ISkinParam skinParam, Display label, Swimlane swimlane, BoxStyle boxStyle, Stereotype stereotype) {
        Style style = FtileBox.getStyleSignature().withTOBECHANGED(stereotype).getMergedStyle(skinParam.getCurrentStyleBuilder());
        Style styleArrow = FtileBox.getStyleSignatureArrow().getMergedStyle(skinParam.getCurrentStyleBuilder());
        return new FtileBox(skinParam, label, swimlane, boxStyle, style, styleArrow);
    }

    private FtileBox(ISkinParam skinParam, Display label, Swimlane swimlane, BoxStyle boxStyle, Style style, Style styleArrow) {
        super(skinParam);
        this.style = style;
        this.boxStyle = boxStyle;
        this.swimlane = swimlane;
        this.inRendering = LinkRendering.create(Rainbow.build(styleArrow, this.getIHtmlColorSet(), skinParam.getThemeStyle()));
        Colors specBack = null;
        if (skinParam instanceof SkinParamColors) {
            specBack = ((SkinParamColors)skinParam).getColors();
        }
        style = style.eventuallyOverride(specBack);
        this.borderColor = style.value(PName.LineColor).asColor(skinParam.getThemeStyle(), this.getIHtmlColorSet());
        this.backColor = style.value(PName.BackGroundColor).asColor(skinParam.getThemeStyle(), this.getIHtmlColorSet());
        FontConfiguration fc = style.getFontConfiguration(skinParam.getThemeStyle(), this.getIHtmlColorSet());
        this.horizontalAlignment = style.getHorizontalAlignment();
        this.padding = style.getPadding();
        this.margin = style.getMargin();
        this.roundCorner = style.value(PName.RoundCorner).asDouble();
        this.shadowing = style.value(PName.Shadowing).asDouble();
        LineBreakStrategy wrapWidth = style.wrapWidth();
        this.minimumWidth = style.value(PName.MinimumWidth).asDouble();
        Sheet sheet = Parser.build(fc, skinParam.getDefaultTextAlignment(this.horizontalAlignment), skinParam, CreoleMode.FULL).createSheet(label);
        this.tb = new SheetBlock2(new SheetBlock1(sheet, wrapWidth, skinParam.getPadding()), new MyStencil(), new UStroke(1.0));
        this.print = label.toString();
    }

    public String toString() {
        return this.print;
    }

    @Override
    public void drawU(UGraphic ug) {
        FtileGeometry dimTotal = this.calculateDimension(ug.getStringBounder());
        double widthTotal = ((Dimension2D)dimTotal).getWidth();
        double heightTotal = ((Dimension2D)dimTotal).getHeight();
        UDrawable shape = this.boxStyle.getUDrawable(widthTotal, heightTotal, this.shadowing, this.roundCorner);
        UStroke thickness = this.style.getStroke();
        ug = this.borderColor == null ? ug.apply(new HColorNone()) : ug.apply(this.borderColor);
        ug = this.backColor == null ? ug.apply(new HColorNone().bg()) : ug.apply(this.backColor.bg());
        ug = ug.apply(thickness);
        shape.drawU(ug);
        if (this.horizontalAlignment == HorizontalAlignment.LEFT) {
            this.tb.drawU(ug.apply(new UTranslate(this.padding.getLeft(), this.padding.getTop())));
        } else if (this.horizontalAlignment == HorizontalAlignment.RIGHT) {
            Dimension2D dimTb = this.tb.calculateDimension(ug.getStringBounder());
            this.tb.drawU(ug.apply(new UTranslate(((Dimension2D)dimTotal).getWidth() - dimTb.getWidth() - this.padding.getRight(), this.padding.getBottom())));
        } else if (this.horizontalAlignment == HorizontalAlignment.CENTER) {
            Dimension2D dimTb = this.tb.calculateDimension(ug.getStringBounder());
            this.tb.drawU(ug.apply(new UTranslate((((Dimension2D)dimTotal).getWidth() - dimTb.getWidth()) / 2.0, this.padding.getBottom())));
        }
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        Dimension2D dimRaw = this.tb.calculateDimension(stringBounder);
        dimRaw = Dimension2DDouble.delta(dimRaw, this.padding.getLeft() + this.padding.getRight(), this.padding.getBottom() + this.padding.getTop());
        dimRaw = Dimension2DDouble.atLeast(dimRaw, this.minimumWidth, 0.0);
        return new FtileGeometry(dimRaw.getWidth() + this.boxStyle.getShield(), dimRaw.getHeight(), dimRaw.getWidth() / 2.0, 0.0, dimRaw.getHeight());
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        return Collections.emptyList();
    }

    class MyStencil
    implements Stencil {
        MyStencil() {
        }

        @Override
        public double getStartingX(StringBounder stringBounder, double y) {
            return -FtileBox.this.padding.getLeft();
        }

        @Override
        public double getEndingX(StringBounder stringBounder, double y) {
            FtileGeometry dim = FtileBox.this.calculateDimension(stringBounder);
            return ((Dimension2D)dim).getWidth() - FtileBox.this.padding.getRight();
        }
    }
}

