/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile;

import java.util.Collection;
import java.util.Collections;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile.GConnection;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile.GConnectionVerticalDown;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile.GtileTopDown;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class GtileAssembly
extends GtileTopDown {
    private final TextBlock textBlock;

    public GtileAssembly(Gtile tile1, Gtile tile2, LinkRendering linkRendering) {
        super(tile1, tile2);
        this.textBlock = this.getTextBlock(linkRendering.getDisplay());
    }

    @Override
    protected UTranslate supplementaryMove() {
        double height = 30.0 + this.textBlock.calculateDimension(this.stringBounder).getHeight();
        return new UTranslate(0.0, height);
    }

    public final StyleSignatureBasic getDefaultStyleDefinitionArrow() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.arrow);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D raw = super.calculateDimension(stringBounder);
        double textBlockWidth = this.textBlock.calculateDimension(stringBounder).getWidth();
        double pos1 = this.tile1.getCoord("SOUTH_HOOK").compose(this.getPos1()).getDx();
        return Dimension2DDouble.atLeast(raw, pos1 + textBlockWidth, 0.0);
    }

    protected final TextBlock getTextBlock(Display display) {
        if (Display.isNull(display)) {
            return TextBlockUtils.EMPTY_TEXT_BLOCK;
        }
        Style style = this.getDefaultStyleDefinitionArrow().getMergedStyle(this.skinParam().getCurrentStyleBuilder());
        FontConfiguration fontConfiguration = style.getFontConfiguration(this.skinParam().getThemeStyle(), this.skinParam().getIHtmlColorSet());
        return display.create7(fontConfiguration, HorizontalAlignment.LEFT, this.skinParam(), CreoleMode.SIMPLE_LINE);
    }

    @Override
    public Collection<GConnection> getInnerConnections() {
        GConnectionVerticalDown arrow = new GConnectionVerticalDown(this.getPos1(), this.tile1.getGPoint("SOUTH_HOOK"), this.getPos2(), this.tile2.getGPoint("NORTH_HOOK"), this.textBlock);
        return Collections.singletonList(arrow);
    }
}

