/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ant;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import znaishaded.net.sourceforge.plantuml.security.SFile;
import znaishaded.net.sourceforge.plantuml.security.SecurityUtils;
import znaishaded.org.apache.tools.ant.BuildException;
import znaishaded.org.apache.tools.ant.Task;
import znaishaded.org.apache.tools.ant.types.FileList;
import znaishaded.org.apache.tools.ant.types.FileSet;

public class CheckZipTask
extends Task {
    private String zipfile = null;
    private List<FileSet> filesets = new ArrayList<FileSet>();
    private List<FileList> filelists = new ArrayList<FileList>();
    private final List<String> entries = new ArrayList<String>();

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void addFilelist(FileList list) {
        this.filelists.add(list);
    }

    @Override
    public void execute() throws BuildException {
        this.myLog("Check " + this.zipfile);
        try {
            this.loadZipFile(new SFile(this.zipfile));
            for (FileList fileList : this.filelists) {
                this.manageFileList(fileList);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BuildException(e.toString());
        }
    }

    private void manageFileList(FileList fileList) {
        String[] srcFiles;
        boolean error = false;
        for (String s2 : srcFiles = fileList.getFiles(this.getProject())) {
            if (this.isPresentInFile(s2)) continue;
            this.myLog("Missing " + s2);
            error = true;
        }
        if (error) {
            throw new BuildException("Some entries are missing in the zipfile");
        }
    }

    private boolean isPresentInFile(String s2) {
        return this.entries.contains(s2);
    }

    private void loadZipFile(SFile file) throws IOException {
        this.entries.clear();
        InputStream tmp = file.openFile();
        if (tmp == null) {
            throw new FileNotFoundException();
        }
        try (PrintWriter pw = SecurityUtils.createPrintWriter("tmp.txt");
             ZipInputStream zis = new ZipInputStream(tmp);){
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                String fileName = ze.getName();
                this.entries.add(fileName);
                if (!fileName.endsWith("/")) {
                    pw.println("<file name=\"" + fileName + "\" />");
                }
                ze = zis.getNextEntry();
            }
        }
    }

    private synchronized void myLog(String s2) {
        this.log(s2);
    }

    public void setZipfile(String s2) {
        this.zipfile = s2;
    }
}

