/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.braille;

import java.io.IOException;
import java.io.OutputStream;
import znaishaded.net.sourceforge.plantuml.braille.BrailleDrawer;
import znaishaded.net.sourceforge.plantuml.braille.BrailleGrid;
import znaishaded.net.sourceforge.plantuml.braille.DriverCenteredCharacterBraille;
import znaishaded.net.sourceforge.plantuml.braille.DriverDotPathBraille;
import znaishaded.net.sourceforge.plantuml.braille.DriverLineBraille;
import znaishaded.net.sourceforge.plantuml.braille.DriverPolygonBraille;
import znaishaded.net.sourceforge.plantuml.braille.DriverRectangleBraille;
import znaishaded.net.sourceforge.plantuml.braille.DriverTextBraille;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.posimo.DotPath;
import znaishaded.net.sourceforge.plantuml.ugraphic.AbstractCommonUGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.AbstractUGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ClipContainer;
import znaishaded.net.sourceforge.plantuml.ugraphic.ImageBuilder;
import znaishaded.net.sourceforge.plantuml.ugraphic.UCenteredCharacter;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UImage;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPath;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPolygon;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UText;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class UGraphicBraille
extends AbstractUGraphic<BrailleGrid>
implements ClipContainer {
    public static final int QUANTA = 4;

    @Override
    protected AbstractCommonUGraphic copyUGraphic() {
        return new UGraphicBraille(this);
    }

    public UGraphicBraille(HColor defaultBackground, ColorMapper colorMapper, StringBounder stringBounder) {
        super(defaultBackground, colorMapper, stringBounder, new BrailleGrid(4.0));
        this.register();
    }

    private UGraphicBraille(UGraphicBraille other) {
        super(other);
        this.register();
    }

    private void register() {
        this.ignoreShape(URectangle.class);
        this.registerDriver(URectangle.class, new DriverRectangleBraille(this));
        this.registerDriver(UText.class, new DriverTextBraille());
        this.registerDriver(ULine.class, new DriverLineBraille(this));
        this.registerDriver(UPolygon.class, new DriverPolygonBraille(this));
        this.ignoreShape(UEllipse.class);
        this.ignoreShape(UImage.class);
        this.ignoreShape(UPath.class);
        this.registerDriver(DotPath.class, new DriverDotPathBraille());
        this.registerDriver(UCenteredCharacter.class, new DriverCenteredCharacterBraille());
    }

    @Override
    public void writeToStream(OutputStream os, String metadata, int dpi) throws IOException {
        ImageBuilder.plainPngBuilder(new BrailleDrawer((BrailleGrid)this.getGraphicObject())).metadata(metadata).write(os);
    }
}

