/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command;

import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.UrlMode;
import znaishaded.net.sourceforge.plantuml.classdiagram.ClassDiagram;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.GroupType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IGroup;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Ident;
import znaishaded.net.sourceforge.plantuml.cucadiagram.NamespaceStrategy;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorParser;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public class CommandNamespaceEmpty
extends SingleLineCommand2<ClassDiagram> {
    public CommandNamespaceEmpty() {
        super(CommandNamespaceEmpty.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandNamespaceEmpty.class.getName(), RegexLeaf.start(), new RegexLeaf("namespace"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("NAME", "([%pLN_][-%pLN_.:\\\\]*)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\{"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\}"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(ClassDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        String color;
        String urlString;
        String idShort = arg.get("NAME", 0);
        Ident idNewLong = diagram.buildLeafIdent(idShort);
        Ident code = diagram.V1972() ? idNewLong : diagram.buildCode(idShort);
        IGroup currentPackage = diagram.getCurrentGroup();
        Display display = Display.getWithNewlines(code);
        diagram.gotoGroup(idNewLong, code, display, GroupType.PACKAGE, currentPackage, NamespaceStrategy.MULTIPLE);
        IGroup p = diagram.getCurrentGroup();
        String stereotype = arg.get("STEREOTYPE", 0);
        if (stereotype != null) {
            p.setStereotype(Stereotype.build(stereotype));
        }
        if ((urlString = arg.get("URL", 0)) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
            Url url = urlBuilder.getUrl(urlString);
            p.addUrl(url);
        }
        if ((color = arg.get("COLOR", 0)) != null) {
            p.setSpecificColorTOBEREMOVED(ColorType.BACK, diagram.getSkinParam().getIHtmlColorSet().getColor(diagram.getSkinParam().getThemeStyle(), color));
        }
        diagram.endGroup();
        return CommandExecutionResult.ok();
    }
}

