/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command.regex;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.StringLocated;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexComposed;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;

public final class RegexConcat
extends RegexComposed
implements IRegex {
    private static final ConcurrentMap<Object, RegexConcat> cache = new ConcurrentHashMap<Object, RegexConcat>();
    private final AtomicLong foxRegex = new AtomicLong(-1L);
    private int limitSize;

    public static void printCacheInfo() {
        int nbCompiled = 0;
        int nbInvoked = 0;
        for (RegexConcat reg : cache.values()) {
            if (reg.isCompiled()) {
                ++nbCompiled;
            }
            if (!reg.invoked()) continue;
            ++nbInvoked;
        }
        Log.info("Regex total/invoked/compiled " + cache.size() + "/" + nbInvoked + "/" + nbCompiled);
        Log.info("Matches created " + nbCreateMatches.get());
    }

    public RegexConcat(IRegex ... partials) {
        super(partials);
    }

    private long foxRegex() {
        if (this.foxRegex.get() == -1L) {
            long tmp = 0L;
            for (int i = 1; i < this.partials().size() - 1; ++i) {
                IRegex part = this.partials().get(i);
                if (!(part instanceof RegexLeaf)) continue;
                RegexLeaf leaf = (RegexLeaf)part;
                tmp |= leaf.getFoxSignature();
            }
            this.foxRegex.set(tmp);
        }
        return this.foxRegex.get();
    }

    public static RegexConcat build(String key, IRegex ... partials) {
        RegexConcat result = (RegexConcat)cache.get(key);
        if (result == null) {
            cache.putIfAbsent(key, RegexConcat.buildInternal(partials));
            result = (RegexConcat)cache.get(key);
        }
        return result;
    }

    private static RegexConcat buildInternal(IRegex ... partials) {
        RegexConcat result = new RegexConcat(partials);
        assert (partials[0] == RegexLeaf.start());
        assert (partials[partials.length - 1] == RegexLeaf.end());
        return result;
    }

    private boolean invoked() {
        return this.foxRegex.get() != -1L;
    }

    @Override
    public boolean match(StringLocated s2) {
        long foxLine;
        long check;
        if (this.limitSize != 0 && s2.getString().length() > this.limitSize) {
            return false;
        }
        long foxRegex = this.foxRegex();
        if (foxRegex != 0L && (check = foxRegex & (foxLine = s2.getFoxSignature())) != foxRegex) {
            return false;
        }
        return super.match(s2);
    }

    @Override
    protected String getFullSlow() {
        StringBuilder sb = new StringBuilder();
        for (IRegex p : this.partials()) {
            sb.append(p.getPattern());
        }
        return sb.toString();
    }

    public RegexConcat protectSize(int size) {
        this.limitSize = size;
        return this;
    }
}

