/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.creole.legacy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import znaishaded.net.sourceforge.plantuml.BackSlash;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.creole.CreoleContext;
import znaishaded.net.sourceforge.plantuml.creole.CreoleHorizontalLine;
import znaishaded.net.sourceforge.plantuml.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.creole.Stripe;
import znaishaded.net.sourceforge.plantuml.creole.StripeStyle;
import znaishaded.net.sourceforge.plantuml.creole.StripeStyleType;
import znaishaded.net.sourceforge.plantuml.creole.atom.Atom;
import znaishaded.net.sourceforge.plantuml.creole.atom.AtomEmoji;
import znaishaded.net.sourceforge.plantuml.creole.atom.AtomImg;
import znaishaded.net.sourceforge.plantuml.creole.atom.AtomMath;
import znaishaded.net.sourceforge.plantuml.creole.atom.AtomOpenIcon;
import znaishaded.net.sourceforge.plantuml.creole.atom.AtomSpace;
import znaishaded.net.sourceforge.plantuml.creole.atom.AtomSprite;
import znaishaded.net.sourceforge.plantuml.creole.command.Command;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleColorAndSizeChange;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleColorChange;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleEmoji;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleExposantChange;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleFontFamilyChange;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleImg;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleLatex;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleMath;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleMonospaced;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleOpenIcon;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleQrcode;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleSizeChange;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleSpace;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleSprite;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleStyle;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleSvgAttributeChange;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleUrl;
import znaishaded.net.sourceforge.plantuml.creole.legacy.AtomTextUtils;
import znaishaded.net.sourceforge.plantuml.emoji.Emoji;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.FontPosition;
import znaishaded.net.sourceforge.plantuml.graphic.FontStyle;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.ImgValign;
import znaishaded.net.sourceforge.plantuml.math.ScientificEquationSafe;
import znaishaded.net.sourceforge.plantuml.openiconic.OpenIcon;
import znaishaded.net.sourceforge.plantuml.security.SecurityUtils;
import znaishaded.net.sourceforge.plantuml.sprite.Sprite;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;
import znaishaded.net.sourceforge.plantuml.utils.CharHidder;

public class StripeSimple
implements Stripe {
    private final Atom header;
    private final List<Atom> atoms = new ArrayList<Atom>();
    private final Map<Character, List<Command>> commands = new HashMap<Character, List<Command>>();
    private HorizontalAlignment align = HorizontalAlignment.LEFT;
    private FontConfiguration fontConfiguration;
    private final StripeStyle style;
    private final ISkinSimple skinParam;

    public void setCellAlignment(HorizontalAlignment align) {
        this.align = align;
    }

    public HorizontalAlignment getCellAlignment() {
        return this.align;
    }

    public String toString() {
        return super.toString() + " " + this.atoms.toString();
    }

    @Override
    public Atom getLHeader() {
        return this.header;
    }

    public StripeSimple(FontConfiguration fontConfiguration, StripeStyle style, CreoleContext context, ISkinSimple skinParam, CreoleMode modeSimpleLine) {
        this.fontConfiguration = fontConfiguration;
        this.style = style;
        this.skinParam = skinParam;
        this.addCommand(CommandCreoleStyle.createCreole(FontStyle.BOLD));
        this.addCommand(CommandCreoleStyle.createLegacy(FontStyle.BOLD));
        this.addCommand(CommandCreoleStyle.createLegacyEol(FontStyle.BOLD));
        this.addCommand(CommandCreoleStyle.createCreole(FontStyle.ITALIC));
        this.addCommand(CommandCreoleStyle.createLegacy(FontStyle.ITALIC));
        this.addCommand(CommandCreoleStyle.createLegacyEol(FontStyle.ITALIC));
        this.addCommand(CommandCreoleStyle.createLegacy(FontStyle.PLAIN));
        this.addCommand(CommandCreoleStyle.createLegacyEol(FontStyle.PLAIN));
        if (modeSimpleLine == CreoleMode.FULL) {
            this.addCommand(CommandCreoleStyle.createCreole(FontStyle.UNDERLINE));
        }
        this.addCommand(CommandCreoleStyle.createLegacy(FontStyle.UNDERLINE));
        this.addCommand(CommandCreoleStyle.createLegacyEol(FontStyle.UNDERLINE));
        this.addCommand(CommandCreoleStyle.createCreole(FontStyle.STRIKE));
        this.addCommand(CommandCreoleStyle.createLegacy(FontStyle.STRIKE));
        this.addCommand(CommandCreoleStyle.createLegacyEol(FontStyle.STRIKE));
        this.addCommand(CommandCreoleStyle.createCreole(FontStyle.WAVE));
        this.addCommand(CommandCreoleStyle.createLegacy(FontStyle.WAVE));
        this.addCommand(CommandCreoleStyle.createLegacyEol(FontStyle.WAVE));
        this.addCommand(CommandCreoleStyle.createLegacy(FontStyle.BACKCOLOR));
        this.addCommand(CommandCreoleStyle.createLegacyEol(FontStyle.BACKCOLOR));
        this.addCommand(CommandCreoleSizeChange.create());
        this.addCommand(CommandCreoleSizeChange.createEol());
        this.addCommand(CommandCreoleColorChange.create());
        this.addCommand(CommandCreoleColorChange.createEol());
        this.addCommand(CommandCreoleColorAndSizeChange.create());
        this.addCommand(CommandCreoleColorAndSizeChange.createEol());
        this.addCommand(CommandCreoleExposantChange.create(FontPosition.EXPOSANT));
        this.addCommand(CommandCreoleExposantChange.create(FontPosition.INDICE));
        this.addCommand(CommandCreoleImg.create());
        this.addCommand(CommandCreoleQrcode.create());
        this.addCommand(CommandCreoleOpenIcon.create());
        this.addCommand(CommandCreoleEmoji.create());
        this.addCommand(CommandCreoleMath.create());
        this.addCommand(CommandCreoleLatex.create());
        this.addCommand(CommandCreoleSprite.create());
        this.addCommand(CommandCreoleSpace.create());
        this.addCommand(CommandCreoleFontFamilyChange.create());
        this.addCommand(CommandCreoleFontFamilyChange.createEol());
        this.addCommand(CommandCreoleMonospaced.create());
        this.addCommand(CommandCreoleUrl.create());
        if (SecurityUtils.allowSvgText()) {
            this.addCommand(CommandCreoleSvgAttributeChange.create());
        }
        this.header = style.getHeader(fontConfiguration, context);
        if (this.header != null) {
            this.atoms.add(this.header);
        }
    }

    private void addCommand(Command cmd) {
        String starters = cmd.startingChars();
        for (int i = 0; i < starters.length(); ++i) {
            char ch = starters.charAt(i);
            List<Command> localList = this.commands.get(Character.valueOf(ch));
            if (localList == null) {
                localList = new ArrayList<Command>();
                this.commands.put(Character.valueOf(ch), localList);
            }
            localList.add(cmd);
        }
    }

    @Override
    public List<Atom> getAtoms() {
        if (this.atoms.size() == 0) {
            this.atoms.add(AtomTextUtils.createLegacy(" ", this.fontConfiguration));
        }
        return Collections.unmodifiableList(this.atoms);
    }

    public FontConfiguration getActualFontConfiguration() {
        return this.fontConfiguration;
    }

    public void setActualFontConfiguration(FontConfiguration fontConfiguration) {
        this.fontConfiguration = fontConfiguration;
    }

    public void analyzeAndAdd(String line) {
        if (Objects.requireNonNull(line).contains("" + BackSlash.hiddenNewLine())) {
            throw new IllegalArgumentException(line);
        }
        line = CharHidder.hide(line);
        if (this.style.getType() == StripeStyleType.HEADING) {
            this.fontConfiguration = StripeSimple.fontConfigurationForHeading(this.fontConfiguration, this.style.getOrder());
            this.modifyStripe(line);
        } else if (this.style.getType() == StripeStyleType.HORIZONTAL_LINE) {
            this.atoms.add(CreoleHorizontalLine.create(this.fontConfiguration, line, this.style.getStyle(), this.skinParam));
        } else {
            this.modifyStripe(line);
        }
    }

    private static FontConfiguration fontConfigurationForHeading(FontConfiguration fontConfiguration, int order) {
        switch (order) {
            case 0: {
                return fontConfiguration.bigger(4.0).bold();
            }
            case 1: {
                return fontConfiguration.bigger(2.0).bold();
            }
            case 2: {
                return fontConfiguration.bigger(1.0).bold();
            }
        }
        return fontConfiguration.italic();
    }

    public void addImage(String src, double scale) {
        this.atoms.add(AtomImg.create(src, ImgValign.TOP, 0, scale, null));
    }

    public void addQrcode(String src, double scale) {
        this.atoms.add(AtomImg.createQrcode(src, scale));
    }

    public void addSpace(int size) {
        this.atoms.add(AtomSpace.create(size));
    }

    public void addUrl(Url url) {
        this.atoms.add(AtomTextUtils.createUrl(url, this.fontConfiguration, this.skinParam));
    }

    public void addSprite(String src, double scale, HColor color) {
        Sprite sprite = this.skinParam.getSprite(src);
        if (sprite != null) {
            this.atoms.add(new AtomSprite(color, scale, this.fontConfiguration, sprite, null, this.skinParam.getColorMapper()));
        }
    }

    public void addOpenIcon(String src, double scale, HColor color) {
        OpenIcon openIcon = OpenIcon.retrieve(src);
        if (openIcon != null) {
            this.atoms.add(new AtomOpenIcon(color, scale, openIcon, this.fontConfiguration, null));
        }
    }

    public void addEmoji(String emojiName, String forcedColor) {
        Emoji emoji = Emoji.retrieve(emojiName);
        if (emoji == null) {
            return;
        }
        HColor col = null;
        if (forcedColor == null) {
            col = null;
        } else if (forcedColor.equals("#0") || forcedColor.equals("#000") || forcedColor.equals("#black")) {
            col = this.fontConfiguration.getColor();
        } else {
            try {
                col = this.skinParam.getIHtmlColorSet().getColor(this.skinParam.getThemeStyle(), forcedColor);
            }
            catch (NoSuchColorException e) {
                col = null;
            }
        }
        this.atoms.add(new AtomEmoji(emoji, 1.0, this.fontConfiguration.getSize2D(), col));
    }

    public void addMath(ScientificEquationSafe math) {
        this.atoms.add(new AtomMath(math, this.fontConfiguration.getColor(), this.fontConfiguration.getExtendedColor(), this.skinParam.getColorMapper()));
    }

    private void modifyStripe(String line) {
        StringBuilder pending = new StringBuilder();
        while (line.length() > 0) {
            Command cmd = this.searchCommand(line);
            if (cmd == null) {
                pending.append(line.charAt(0));
                line = line.substring(1);
                continue;
            }
            this.addPending(pending);
            line = cmd.executeAndGetRemaining(line, this);
        }
        this.addPending(pending);
    }

    private void addPending(StringBuilder pending) {
        if (pending.length() == 0) {
            return;
        }
        this.atoms.add(AtomTextUtils.createLegacy(pending.toString(), this.fontConfiguration));
        pending.setLength(0);
    }

    private Command searchCommand(String line) {
        List<Command> localList = this.commands.get(Character.valueOf(line.charAt(0)));
        if (localList != null) {
            for (Command cmd : localList) {
                if (cmd.matchingSize(line) == 0) continue;
                return cmd;
            }
        }
        return null;
    }

    public ISkinSimple getSkinParam() {
        return this.skinParam;
    }
}

