/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cucadiagram;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.net.sourceforge.plantuml.EmbeddedDiagram;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.creole.Parser;
import znaishaded.net.sourceforge.plantuml.creole.legacy.CreoleParser;
import znaishaded.net.sourceforge.plantuml.cucadiagram.BodyEnhancedAbstract;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LeafType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Member;
import znaishaded.net.sourceforge.plantuml.cucadiagram.MethodsOrFieldsArea;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.InnerStrategy;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockVertical2;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.svek.Ports;
import znaishaded.net.sourceforge.plantuml.svek.WithPorts;

public class BodyEnhanced1
extends BodyEnhancedAbstract
implements TextBlock,
WithPorts {
    private final Display rawBody2;
    private final ISkinParam skinParam;
    private final boolean lineFirst;
    private final List<Url> urls = new ArrayList<Url>();
    private final ILeaf entity;
    private final boolean inEllipse;
    private final Style style;

    BodyEnhanced1(HorizontalAlignment align, List<CharSequence> rawBody, ISkinParam skinParam, ILeaf entity, Style style) {
        super(align, style.getFontConfiguration(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet(), entity.getColors()), style);
        this.style = style;
        this.rawBody2 = Display.create(rawBody);
        this.skinParam = skinParam;
        this.lineFirst = true;
        this.entity = entity;
        this.inEllipse = false;
    }

    BodyEnhanced1(HorizontalAlignment align, Display display, ISkinParam skinParam, ILeaf entity, Style style) {
        super(align, style.getFontConfiguration(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet(), entity.getColors()), style);
        this.style = style;
        this.entity = entity;
        this.skinParam = skinParam;
        this.lineFirst = false;
        LeafType leafType = entity.getLeafType();
        boolean bl = this.inEllipse = leafType == LeafType.USECASE || leafType == LeafType.USECASE_BUSINESS;
        if (this.inEllipse && display.size() > 0 && BodyEnhanced1.isBlockSeparator(display.get(0).toString())) {
            display = display.add("");
        }
        this.rawBody2 = display;
    }

    @Override
    protected double getMarginX() {
        return 6.0;
    }

    private static boolean isTreeOrTable(String s2) {
        return Parser.isTreeStart(s2 = StringUtils.trinNoTrace(s2)) || CreoleParser.isTableLine(s2);
    }

    @Override
    protected final TextBlock getArea(StringBounder stringBounder) {
        if (this.area != null) {
            return this.area;
        }
        this.urls.clear();
        ArrayList<TextBlock> blocks = new ArrayList<TextBlock>();
        char separator = this.lineFirst ? (char)'_' : '\u0000';
        TextBlock title = null;
        Display display = null;
        Iterator it = this.rawBody2.iterator();
        while (it.hasNext()) {
            CharSequence cs = (CharSequence)it.next();
            if (cs instanceof EmbeddedDiagram) {
                if (display == null) {
                    display = Display.empty();
                }
                if (display.size() > 0 || separator != '\u0000') {
                    blocks.add(this.decorate(stringBounder, new MethodsOrFieldsArea(display, this.skinParam, this.align, this.entity, this.style), separator, title));
                    separator = '\u0000';
                    title = null;
                    display = null;
                }
                blocks.add(TextBlockUtils.withMargin(((EmbeddedDiagram)cs).asDraw(this.skinParam), 2.0, 2.0));
                continue;
            }
            String s2 = cs.toString();
            if (BodyEnhanced1.isBlockSeparator(s2)) {
                if (display == null) {
                    display = Display.empty();
                }
                blocks.add(this.decorate(stringBounder, new MethodsOrFieldsArea(display, this.skinParam, this.align, this.entity, this.style), separator, title));
                separator = s2.charAt(0);
                title = this.getTitle(s2, this.skinParam);
                display = null;
                continue;
            }
            if (BodyEnhanced1.isTreeOrTable(s2)) {
                boolean isTable = CreoleParser.isTableLine(s2);
                if (display == null) {
                    display = Display.empty();
                }
                blocks.add(this.decorate(stringBounder, new MethodsOrFieldsArea(display, this.skinParam, this.align, this.entity, this.style), separator, title));
                separator = '\u0000';
                title = null;
                display = null;
                List<CharSequence> allTree = BodyEnhanced1.buildTreeOrTable(s2, (ListIterator<CharSequence>)it);
                FontConfiguration fontConfiguration = this.style.getFontConfiguration(this.skinParam.getThemeStyle(), this.skinParam.getIHtmlColorSet());
                TextBlock bloc = Display.create(allTree).create7(fontConfiguration, this.align, this.skinParam, CreoleMode.FULL);
                if (isTable) {
                    bloc = TextBlockUtils.withMargin(bloc, 10.0, 10.0, 0.0, 5.0);
                }
                blocks.add(bloc);
                continue;
            }
            if (display == null) {
                display = Display.empty();
            }
            display = display.add(cs);
            if (!(cs instanceof Member) || ((Member)cs).getUrl() == null) continue;
            this.urls.add(((Member)cs).getUrl());
        }
        if (display == null) {
            display = Display.empty();
        }
        if (this.inEllipse && display.size() == 0) {
            display = display.add("");
        }
        blocks.add(this.decorate(stringBounder, new MethodsOrFieldsArea(display, this.skinParam, this.align, this.entity, this.style), separator, title));
        this.area = blocks.size() == 1 ? (TextBlock)blocks.get(0) : new TextBlockVertical2(blocks, this.align);
        if (this.skinParam.minClassWidth() > 0.0) {
            this.area = TextBlockUtils.withMinWidth(this.area, this.skinParam.minClassWidth(), this.align);
        }
        return this.area;
    }

    private static List<CharSequence> buildTreeOrTable(String init, ListIterator<CharSequence> it) {
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        Pattern p = Pattern.compile("^(\\s+)");
        Matcher m3 = p.matcher(init);
        String start = "";
        if (m3.find()) {
            start = m3.group(1);
        }
        result.add(BodyEnhanced1.purge(init, start));
        while (it.hasNext()) {
            String s2 = it.next().toString();
            if (BodyEnhanced1.isTreeOrTable(s2)) {
                result.add(BodyEnhanced1.purge(s2, start));
                continue;
            }
            it.previous();
            return result;
        }
        return result;
    }

    private static String purge(String s2, String start) {
        if (s2.startsWith(start)) {
            return s2.substring(start.length());
        }
        return s2;
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        TextBlock area = this.getArea(stringBounder);
        if (area instanceof WithPorts) {
            return ((WithPorts)((Object)area)).getPorts(stringBounder);
        }
        return new Ports();
    }

    public List<Url> getUrls() {
        return Collections.unmodifiableList(this.urls);
    }

    @Override
    public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
        return this.getArea(stringBounder).getInnerPosition(member, stringBounder, strategy);
    }
}

