/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cucadiagram;

import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.json.JsonArray;
import znaishaded.net.sourceforge.plantuml.json.JsonObject;
import znaishaded.net.sourceforge.plantuml.json.JsonValue;
import znaishaded.net.sourceforge.plantuml.svek.Ports;
import znaishaded.net.sourceforge.plantuml.svek.WithPorts;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class TextBlockCucaJSon
extends AbstractTextBlock
implements WithPorts {
    private final FontParam fontParam;
    private final ISkinParam skinParam;
    private final FontConfiguration fontConfiguration;
    private final JsonValue json;
    private TextBlockJson jsonTextBlock;
    private double totalWidth;

    public TextBlockCucaJSon(FontConfiguration fontConfiguration, FontParam fontParam, ISkinParam skinParam, JsonValue json) {
        this.fontParam = fontParam;
        this.skinParam = skinParam;
        this.json = json;
        this.fontConfiguration = fontConfiguration;
    }

    private TextBlockJson getJsonTextBlock() {
        if (this.jsonTextBlock == null) {
            this.jsonTextBlock = new TextBlockJson(this.json, 0.0);
        }
        this.jsonTextBlock.totalWidth = this.totalWidth;
        return this.jsonTextBlock;
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        return new Ports();
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.getJsonTextBlock().calculateDimension(stringBounder);
    }

    @Override
    public void drawU(UGraphic ug) {
        this.getJsonTextBlock().drawU(ug);
    }

    private TextBlock getTextBlockValue(JsonValue value, double width2) {
        if (value.isString() || value.isNull() || value.isTrue() || value.isFalse() || value.isNumber()) {
            String tmp = value.isString() ? value.asString() : value.toString();
            Display display = Display.getWithNewlines(tmp);
            TextBlock result = display.create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
            result = TextBlockUtils.withMargin(result, 5.0, 2.0);
            return result;
        }
        if (value.isArray()) {
            return new TextBlockArray(value.asArray(), width2);
        }
        if (value.isObject()) {
            return new TextBlockJson(value, width2);
        }
        String tmp = value.getClass().getSimpleName();
        Display display = Display.getWithNewlines(tmp);
        TextBlock result = display.create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
        result = TextBlockUtils.withMargin(result, 5.0, 2.0);
        return result;
    }

    private TextBlock getTextBlockKey(String key) {
        Display display = Display.getWithNewlines(key);
        TextBlock result = display.create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
        result = TextBlockUtils.withMargin(result, 5.0, 2.0);
        return result;
    }

    private FontConfiguration getFontConfiguration() {
        if (this.fontConfiguration == null) {
            return FontConfiguration.create(this.skinParam, this.fontParam, null);
        }
        return this.fontConfiguration;
    }

    public void setTotalWidth(double totalWidth) {
        this.totalWidth = totalWidth;
    }

    class TextBlockArray
    extends AbstractTextBlock {
        private final JsonArray array;
        private final double totalWidth;

        public TextBlockArray(JsonArray array, double totalWidth) {
            this.array = array;
            this.totalWidth = totalWidth;
        }

        @Override
        public Dimension2D calculateDimension(StringBounder stringBounder) {
            Dimension2D result = new Dimension2DDouble(0.0, 0.0);
            for (JsonValue element : this.array) {
                TextBlock tb = TextBlockCucaJSon.this.getTextBlockValue(element, this.totalWidth);
                Dimension2D dim = tb.calculateDimension(stringBounder);
                result = Dimension2DDouble.mergeTB(result, dim);
            }
            return result;
        }

        @Override
        public void drawU(UGraphic ug) {
            ULine hline = ULine.hline(this.totalWidth);
            int nb = 0;
            for (JsonValue element : this.array) {
                TextBlock tb = TextBlockCucaJSon.this.getTextBlockValue(element, this.totalWidth);
                if (nb > 0) {
                    ug.draw(hline);
                }
                ++nb;
                tb.drawU(ug);
                ug = ug.apply(UTranslate.dy(tb.calculateDimension(ug.getStringBounder()).getHeight()));
            }
        }
    }

    class TextBlockJson
    extends AbstractTextBlock {
        private final JsonObject obj;
        private double totalWidth;

        public TextBlockJson(JsonValue json, double totalWidth) {
            this.obj = json.asObject();
            this.totalWidth = totalWidth;
        }

        @Override
        public Dimension2D calculateDimension(StringBounder stringBounder) {
            return new Dimension2DDouble(this.getWidth1(stringBounder) + this.getWidth2(stringBounder), this.getHeight(stringBounder));
        }

        private double getWidth1(StringBounder stringBounder) {
            double result = 0.0;
            for (JsonObject.Member s2 : this.obj) {
                TextBlock tb1 = TextBlockCucaJSon.this.getTextBlockKey(s2.getName());
                result = Math.max(result, tb1.calculateDimension(stringBounder).getWidth());
            }
            return result;
        }

        private double getWidth2(StringBounder stringBounder) {
            double result = 0.0;
            for (JsonObject.Member s2 : this.obj) {
                TextBlock tb2 = TextBlockCucaJSon.this.getTextBlockValue(s2.getValue(), this.totalWidth);
                result = Math.max(result, tb2.calculateDimension(stringBounder).getWidth());
            }
            return result;
        }

        private double getHeight(StringBounder stringBounder) {
            double result = 0.0;
            for (JsonObject.Member s2 : this.obj) {
                TextBlock tb1 = TextBlockCucaJSon.this.getTextBlockKey(s2.getName());
                TextBlock tb2 = TextBlockCucaJSon.this.getTextBlockValue(s2.getValue(), this.totalWidth);
                Dimension2D dim1 = tb1.calculateDimension(stringBounder);
                Dimension2D dim2 = tb2.calculateDimension(stringBounder);
                result += Math.max(dim1.getHeight(), dim2.getHeight());
            }
            return result;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            double width1 = this.getWidth1(stringBounder);
            double width2 = this.getWidth2(stringBounder);
            double height = this.getHeight(stringBounder);
            ug.apply(UTranslate.dx(width1)).draw(ULine.vline(height));
            ULine hline = ULine.hline(this.totalWidth);
            for (JsonObject.Member s2 : this.obj) {
                TextBlock tb1 = TextBlockCucaJSon.this.getTextBlockKey(s2.getName());
                TextBlock tb2 = TextBlockCucaJSon.this.getTextBlockValue(s2.getValue(), width2);
                Dimension2D dim1 = tb1.calculateDimension(stringBounder);
                Dimension2D dim2 = tb2.calculateDimension(stringBounder);
                ug.draw(hline);
                tb1.drawU(ug);
                tb2.drawU(ug.apply(UTranslate.dx(width1)));
                ug = ug.apply(UTranslate.dy(Math.max(dim1.getHeight(), dim2.getHeight())));
            }
        }
    }
}

