/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import znaishaded.net.sourceforge.plantuml.api.ThemeStyle;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LinkType;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.graphic.color.Colors;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorSet;

public abstract class WithLinkType {
    protected LinkType type;
    protected boolean hidden = false;
    private boolean single = false;
    private Colors colors = Colors.empty();
    private List<Colors> supplementary = new ArrayList<Colors>();

    public final HColor getSpecificColor() {
        return this.colors.getColor(ColorType.LINE);
    }

    public final void setSpecificColor(HColor specificColor) {
        this.setSpecificColor(specificColor, 0);
    }

    public final void setSpecificColor(HColor specificColor, int i) {
        if (i == 0) {
            this.colors = this.colors.add(ColorType.LINE, specificColor);
        } else {
            this.supplementary.add(this.colors.add(ColorType.LINE, specificColor));
        }
    }

    public List<Colors> getSupplementaryColors() {
        return Collections.unmodifiableList(this.supplementary);
    }

    public void setColors(Colors colors) {
        this.colors = colors;
    }

    public final Colors getColors() {
        return this.colors;
    }

    public final void goDashed() {
        this.type = this.type.goDashed();
    }

    public final void goDotted() {
        this.type = this.type.goDotted();
    }

    public final void goThickness(double thickness) {
        this.type = this.type.goThickness(thickness);
    }

    public final void goHidden() {
        this.hidden = true;
    }

    public abstract void goNorank();

    public final void goBold() {
        this.type = this.type.goBold();
    }

    public final void goSingle() {
        this.single = true;
    }

    public boolean isSingle() {
        return this.single;
    }

    public void applyStyle(ThemeStyle themeStyle, String arrowStyle) {
        if (arrowStyle == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(arrowStyle, ";");
        int i = 0;
        while (st.hasMoreTokens()) {
            String s2 = st.nextToken();
            this.applyOneStyle(themeStyle, s2, i);
            ++i;
        }
    }

    private void applyOneStyle(ThemeStyle themeStyle, String arrowStyle, int i) {
        StringTokenizer st = new StringTokenizer(arrowStyle, ",");
        while (st.hasMoreTokens()) {
            String s2 = st.nextToken();
            if (s2.equalsIgnoreCase("dashed")) {
                this.goDashed();
                continue;
            }
            if (s2.equalsIgnoreCase("bold")) {
                this.goBold();
                continue;
            }
            if (s2.equalsIgnoreCase("dotted")) {
                this.goDotted();
                continue;
            }
            if (s2.equalsIgnoreCase("hidden")) {
                this.goHidden();
                continue;
            }
            if (s2.equalsIgnoreCase("single")) {
                this.goSingle();
                continue;
            }
            if (s2.equalsIgnoreCase("plain")) continue;
            if (s2.equalsIgnoreCase("norank")) {
                this.goNorank();
                continue;
            }
            if (s2.startsWith("thickness=")) {
                this.goThickness(Double.parseDouble(s2.substring("thickness=".length())));
                continue;
            }
            HColor tmp = HColorSet.instance().getColorOrWhite(themeStyle, s2);
            this.setSpecificColor(tmp, i);
        }
    }

    public LinkType getType() {
        return this.type;
    }

    public UStroke getUStroke() {
        throw new UnsupportedOperationException();
    }
}

