/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.descdiagram.command;

import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.UrlMode;
import znaishaded.net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import znaishaded.net.sourceforge.plantuml.classdiagram.command.CommandCreateClassMultilines;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOptional;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOr;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Code;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Ident;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LeafType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotag;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.descdiagram.DescriptionDiagram;
import znaishaded.net.sourceforge.plantuml.graphic.USymbol;
import znaishaded.net.sourceforge.plantuml.graphic.USymbols;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorParser;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.graphic.color.Colors;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public class CommandCreateElementFull
extends SingleLineCommand2<DescriptionDiagram> {
    public static final String ALL_TYPES = "person|artifact|actor/|actor|folder|card|file|package|rectangle|hexagon|label|node|frame|cloud|database|queue|stack|storage|agent|usecase/|usecase|component|boundary|control|entity|interface|circle|collections|port|portin|portout";
    private static final String CODE_CORE = "[%pLN_.]+|\\(\\)[%s]*[%pLN_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\]";
    public static final String CODE = "([%pLN_.]+|\\(\\)[%s]*[%pLN_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\])";
    public static final String CODE_WITH_QUOTE = "([%pLN_.]+|\\(\\)[%s]*[%pLN_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\]|[%g].+?[%g])";
    private static final String DISPLAY_CORE = "[%g].+?[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\]";
    public static final String DISPLAY = "([%g].+?[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\])";
    public static final String DISPLAY_WITHOUT_QUOTE = "([%g].+?[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\]|[%pLN_.]+)";

    public CommandCreateElementFull() {
        super(CommandCreateElementFull.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandCreateElementFull.class.getName(), RegexLeaf.start(), new RegexLeaf("SYMBOL", "(?:(person|artifact|actor/|actor|folder|card|file|package|rectangle|hexagon|label|node|frame|cloud|database|queue|stack|storage|agent|usecase/|usecase|component|boundary|control|entity|interface|circle|collections|port|portin|portout|\\(\\))[%s]+)?"), CommandCreateElementFull.color2().getRegex(), RegexLeaf.spaceZeroOrMore(), new RegexOr(new RegexLeaf("CODE1", CODE_WITH_QUOTE), new RegexConcat(new RegexLeaf("DISPLAY2", DISPLAY), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("STEREOTYPE2", "(\\<\\<.+\\>\\>)"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE2", CODE)), new RegexConcat(new RegexLeaf("CODE3", CODE), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("STEREOTYPE3", "(\\<\\<.+\\>\\>)"))), RegexLeaf.spaceOneOrMore(), new RegexLeaf("as"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("DISPLAY3", DISPLAY)), new RegexConcat(new RegexLeaf("DISPLAY4", DISPLAY_WITHOUT_QUOTE), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("STEREOTYPE4", "(\\<\\<.+\\>\\>)"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE4", CODE))), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREOTYPE", "(\\<\\<.+\\>\\>)"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS", Stereotag.pattern() + "?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), RegexLeaf.spaceZeroOrMore(), CommandCreateElementFull.color().getRegex(), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    private static ColorParser color2() {
        return ColorParser.simpleColor(ColorType.BACK, "COLOR2");
    }

    @Override
    protected final boolean isForbidden(CharSequence line) {
        return line.toString().matches("^[\\p{L}0-9_.]+$");
    }

    @Override
    protected CommandExecutionResult executeArg(DescriptionDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        HColor lineColor;
        Ident code;
        USymbol usymbol;
        LeafType type;
        String symbol;
        String codeRaw = arg.getLazzy("CODE", 0);
        String displayRaw = arg.getLazzy("DISPLAY", 0);
        char codeChar = this.getCharEncoding(codeRaw);
        char codeDisplay = this.getCharEncoding(displayRaw);
        if (codeRaw.startsWith("()")) {
            symbol = "interface";
            codeRaw = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(codeRaw.substring(2)));
        } else if (codeChar == '(' || codeDisplay == '(') {
            if (arg.get("SYMBOL", 0) != null && arg.get("SYMBOL", 0).endsWith("/")) {
                symbol = "usecase/";
            } else if (displayRaw != null && displayRaw.endsWith(")/")) {
                displayRaw = displayRaw.substring(0, displayRaw.length() - 1);
                symbol = "usecase/";
            } else if (codeRaw.endsWith(")/")) {
                codeRaw = codeRaw.substring(0, codeRaw.length() - 1);
                symbol = "usecase/";
            } else {
                symbol = "usecase";
            }
        } else if (codeChar == ':' || codeDisplay == ':') {
            if (arg.get("SYMBOL", 0) != null && arg.get("SYMBOL", 0).endsWith("/")) {
                symbol = "actor/";
            } else if (displayRaw != null && displayRaw.endsWith(":/")) {
                displayRaw = displayRaw.substring(0, displayRaw.length() - 1);
                symbol = "actor/";
            } else if (codeRaw.endsWith(":/")) {
                codeRaw = codeRaw.substring(0, codeRaw.length() - 1);
                symbol = "actor/";
            } else {
                symbol = "actor";
            }
        } else {
            symbol = codeChar == '[' || codeDisplay == '[' ? "component" : arg.get("SYMBOL", 0);
        }
        if (symbol == null) {
            type = LeafType.DESCRIPTION;
            usymbol = diagram.getSkinParam().actorStyle().toUSymbol();
        } else if (symbol.equalsIgnoreCase("portin")) {
            type = LeafType.PORTIN;
            usymbol = null;
        } else if (symbol.equalsIgnoreCase("portout")) {
            type = LeafType.PORTOUT;
            usymbol = null;
        } else if (symbol.equalsIgnoreCase("port")) {
            type = LeafType.PORT;
            usymbol = null;
        } else if (symbol.equalsIgnoreCase("usecase")) {
            type = LeafType.USECASE;
            usymbol = null;
        } else if (symbol.equalsIgnoreCase("usecase/")) {
            type = LeafType.USECASE_BUSINESS;
            usymbol = null;
        } else if (symbol.equalsIgnoreCase("circle")) {
            type = LeafType.CIRCLE;
            usymbol = null;
        } else {
            type = LeafType.DESCRIPTION;
            usymbol = USymbols.fromString(symbol, diagram.getSkinParam());
            if (usymbol == null) {
                throw new IllegalStateException();
            }
        }
        String idShort = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(codeRaw);
        Ident ident = diagram.buildLeafIdent(idShort);
        Code code2 = code = diagram.V1972() ? ident : diagram.buildCode(idShort);
        if (!diagram.V1972() && diagram.isGroup(code)) {
            return CommandExecutionResult.error("This element (" + code.getName() + ") is already defined");
        }
        if (diagram.V1972() && diagram.isGroupStrict(ident)) {
            return CommandExecutionResult.error("This element (" + ident.getName() + ") is already defined");
        }
        String display = displayRaw;
        if (display == null) {
            display = code.getName();
        }
        display = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(display);
        String stereotype = arg.getLazzy("STEREOTYPE", 0);
        if (CommandCreateElementFull.existsWithBadType3(diagram, code, ident, type, usymbol)) {
            return CommandExecutionResult.error("This element (" + code.getName() + ") is already defined");
        }
        ILeaf entity = diagram.getOrCreateLeaf(ident, code, type, usymbol);
        entity.setDisplay(Display.getWithNewlines(display));
        entity.setUSymbol(usymbol);
        if (stereotype != null) {
            entity.setStereotype(Stereotype.build(stereotype, diagram.getSkinParam().getCircledCharacterRadius(), diagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), diagram.getSkinParam().getIHtmlColorSet()));
        }
        CommandCreateClassMultilines.addTags(entity, arg.get("TAGS", 0));
        String urlString = arg.get("URL", 0);
        if (urlString != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
            Url url = urlBuilder.getUrl(urlString);
            entity.addUrl(url);
        }
        Colors colors = CommandCreateElementFull.color().getColor(diagram.getSkinParam().getThemeStyle(), arg, diagram.getSkinParam().getIHtmlColorSet());
        String s2 = arg.get("LINECOLOR", 1);
        HColor hColor = lineColor = s2 == null ? null : diagram.getSkinParam().getIHtmlColorSet().getColor(diagram.getSkinParam().getThemeStyle(), s2);
        if (lineColor != null) {
            colors = colors.add(ColorType.LINE, lineColor);
        }
        entity.setColors(colors);
        return CommandExecutionResult.ok();
    }

    public static boolean existsWithBadType3(AbstractEntityDiagram diagram, Code code, Ident ident, LeafType type, USymbol usymbol) {
        if (diagram.V1972()) {
            if (!diagram.leafExistSmart(ident)) {
                return false;
            }
            ILeaf other = diagram.getLeafSmart(ident);
            if (other.getLeafType() != type) {
                return true;
            }
            return usymbol != null && other.getUSymbol() != usymbol;
        }
        if (!diagram.leafExist(code)) {
            return false;
        }
        ILeaf other = diagram.getLeaf(code);
        if (other.getLeafType() != type) {
            return true;
        }
        return usymbol != null && other.getUSymbol() != usymbol;
    }

    private char getCharEncoding(String codeRaw) {
        return codeRaw != null && codeRaw.length() > 2 ? codeRaw.charAt(0) : (char)'\u0000';
    }
}

