/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.eggs;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import znaishaded.net.sourceforge.plantuml.EmptyImageBuilder;
import znaishaded.net.sourceforge.plantuml.FileFormat;
import znaishaded.net.sourceforge.plantuml.api.ImageDataSimple;
import znaishaded.net.sourceforge.plantuml.core.ImageData;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.png.PngIO;
import znaishaded.net.sourceforge.plantuml.ugraphic.UMotif;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;
import znaishaded.net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;

public class GraphicsPath {
    private final String path;
    private final ColorMapper colorMapper;

    public GraphicsPath(ColorMapper colorMapper, String path) {
        this.path = path;
        this.colorMapper = colorMapper;
    }

    public ImageData writeImage(OutputStream os) throws IOException {
        BufferedImage im = this.createImage();
        PngIO.write((RenderedImage)im, os, 96);
        return new ImageDataSimple(im.getWidth(), im.getHeight());
    }

    private BufferedImage createImage() {
        StringBounder stringBounder = FileFormat.PNG.getDefaultStringBounder();
        EmptyImageBuilder builder = new EmptyImageBuilder(null, 50, 50, Color.WHITE, stringBounder);
        BufferedImage im = builder.getBufferedImage();
        Graphics2D g2d = builder.getGraphics2D();
        UGraphicG2d ug = new UGraphicG2d(HColorUtils.WHITE, this.colorMapper, stringBounder, g2d, 1.0);
        ug.setBufferedImage(im);
        UMotif motif = new UMotif(this.path);
        motif.drawHorizontal(ug.apply(HColorUtils.BLACK), 20.0, 20.0, 1);
        g2d.dispose();
        return im;
    }
}

