/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graphic;

import java.awt.geom.Point2D;
import java.util.Objects;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.svek.GuideLine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPolygon;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class TextBlockArrow2
extends AbstractTextBlock
implements TextBlock {
    private final double size;
    private final GuideLine angle;
    private final HColor color;

    public TextBlockArrow2(GuideLine angle, FontConfiguration fontConfiguration) {
        this.angle = Objects.requireNonNull(angle);
        this.size = fontConfiguration.getFont().getSize2D();
        this.color = fontConfiguration.getColor();
    }

    @Override
    public void drawU(UGraphic ug) {
        int triSize = (int)(this.size * 0.8);
        ug = ug.apply(this.color);
        ug = ug.apply(this.color.bg());
        ug = ug.apply(new UTranslate(triSize / 2, this.size / 2.0));
        UPolygon triangle = new UPolygon();
        double beta = 2.5132741228718345;
        triangle.addPoint(this.getPoint(triSize / 2, this.angle.getArrowDirection2()));
        triangle.addPoint(this.getPoint(triSize / 2, this.angle.getArrowDirection2() + 2.5132741228718345));
        triangle.addPoint(this.getPoint(triSize / 2, this.angle.getArrowDirection2() - 2.5132741228718345));
        triangle.addPoint(this.getPoint(triSize / 2, this.angle.getArrowDirection2()));
        ug.draw(triangle);
    }

    private Point2D getPoint(double len, double alpha) {
        double dx = len * Math.sin(alpha);
        double dy = len * Math.cos(alpha);
        return new Point2D.Double(dx, dy);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(this.size, this.size);
    }
}

