/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.logo;

import java.util.HashMap;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.logo.LogoToken;

class LogoScanner {
    private final Map<String, Integer> keywordTable = new HashMap<String, Integer>();
    private char[] sourceString;
    private int sourceLength;
    private int i;

    public LogoScanner() {
        this.keywordTable.put("forward", 260);
        this.keywordTable.put("fd", 260);
        this.keywordTable.put("back", 261);
        this.keywordTable.put("bk", 261);
        this.keywordTable.put("right", 263);
        this.keywordTable.put("rt", 263);
        this.keywordTable.put("left", 262);
        this.keywordTable.put("lt", 262);
        this.keywordTable.put("penup", 264);
        this.keywordTable.put("pu", 264);
        this.keywordTable.put("pendown", 265);
        this.keywordTable.put("pd", 265);
        this.keywordTable.put("hideturtle", 266);
        this.keywordTable.put("ht", 266);
        this.keywordTable.put("showturtle", 267);
        this.keywordTable.put("st", 267);
        this.keywordTable.put("clearscreen", 268);
        this.keywordTable.put("cs", 268);
        this.keywordTable.put("repeat", 269);
        this.keywordTable.put("rep", 269);
        this.keywordTable.put("to", 271);
        this.keywordTable.put("setpc", 272);
        this.keywordTable.put("pc", 272);
    }

    public int getPosition() {
        return this.i;
    }

    public void setPosition(int newPosition) {
        this.i = this.i >= 0 && this.i <= this.sourceLength ? newPosition : this.sourceLength;
    }

    public void setSourceString(String newSourceString) {
        this.sourceLength = newSourceString.length();
        this.sourceString = newSourceString.concat("\u0000").toCharArray();
        this.i = 0;
    }

    public String getSourceString() {
        return new String(this.sourceString);
    }

    public String getRestAsString() {
        this.skipWhitespace();
        String rest = new String(this.sourceString, this.i, this.sourceLength - this.i + 1);
        this.i = this.sourceLength;
        return rest;
    }

    void skipWhitespace() {
        char c;
        while ((c = this.sourceString[this.i++]) == ' ' || c == '\t') {
        }
        --this.i;
    }

    public LogoToken getToken() {
        LogoToken token = new LogoToken();
        StringBuilder lexeme = new StringBuilder();
        if (this.i >= this.sourceLength) {
            token.kind = 256;
            return token;
        }
        this.skipWhitespace();
        char c = this.sourceString[this.i++];
        if (c == '[' || c == ']') {
            token.kind = c;
            token.lexeme = String.valueOf(c);
        } else if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
            do {
                lexeme.append(c);
            } while ((c = this.sourceString[this.i++]) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z');
            --this.i;
            token.lexeme = lexeme.toString();
            token.kind = 258;
            Integer keyword = this.keywordTable.get(token.lexeme);
            if (keyword != null) {
                token.kind = keyword;
            }
        } else if (c >= '0' && c <= '9') {
            do {
                lexeme.append(c);
            } while ((c = this.sourceString[this.i++]) >= '0' && c <= '9');
            boolean hasDecimalPart = false;
            if (c == '.') {
                do {
                    lexeme.append(c);
                } while ((c = this.sourceString[this.i++]) >= '0' && c <= '9');
                hasDecimalPart = true;
            }
            --this.i;
            token.lexeme = lexeme.toString();
            token.value = Float.parseFloat(token.lexeme);
            if (hasDecimalPart) {
                token.kind = 259;
            } else {
                token.kind = 270;
                token.intValue = Integer.parseInt(token.lexeme);
            }
        } else if (c == '\u0000') {
            --this.i;
            token.kind = 256;
        } else {
            --this.i;
            token.kind = 257;
        }
        return token;
    }
}

