/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.logo;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.AbstractPSystem;
import znaishaded.net.sourceforge.plantuml.EmptyImageBuilder;
import znaishaded.net.sourceforge.plantuml.FileFormat;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.api.ImageDataSimple;
import znaishaded.net.sourceforge.plantuml.core.DiagramDescription;
import znaishaded.net.sourceforge.plantuml.core.ImageData;
import znaishaded.net.sourceforge.plantuml.core.UmlSource;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.logo.TinyJavaLogo;
import znaishaded.net.sourceforge.plantuml.logo.TurtleGraphicsPane;
import znaishaded.net.sourceforge.plantuml.png.PngIO;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;
import znaishaded.net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;

public class PSystemLogo
extends AbstractPSystem {
    private final List<String> lines = new ArrayList<String>();

    public PSystemLogo(UmlSource source) {
        super(source);
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat) throws IOException {
        int width = 640;
        int height = 480;
        StringBounder stringBounder = FileFormat.PNG.getDefaultStringBounder();
        EmptyImageBuilder builder = new EmptyImageBuilder(fileFormat.getWatermark(), 640, 480, Color.WHITE, stringBounder);
        BufferedImage im = builder.getBufferedImage();
        UGraphicG2d ug = new UGraphicG2d(HColorUtils.WHITE, new ColorMapperIdentity(), stringBounder, builder.getGraphics2D(), 1.0);
        ug.setBufferedImage(im);
        TurtleGraphicsPane turtleGraphicsPane = new TurtleGraphicsPane(640, 480);
        TinyJavaLogo tinyJavaLogo = new TinyJavaLogo(turtleGraphicsPane);
        for (String line : this.lines) {
            tinyJavaLogo.doCommandLine(line);
        }
        turtleGraphicsPane.paint(ug);
        PngIO.write((RenderedImage)im, os, 96);
        return new ImageDataSimple(im.getWidth(), im.getHeight());
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Logo)");
    }

    public void doCommandLine(String line) {
        this.lines.add(line);
    }
}

