/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.math;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Icon;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.math.ConverterSvg;
import znaishaded.net.sourceforge.plantuml.math.ScientificEquation;
import znaishaded.net.sourceforge.plantuml.math.TeXIconBuilder;
import znaishaded.net.sourceforge.plantuml.ugraphic.MutableImage;
import znaishaded.net.sourceforge.plantuml.ugraphic.UImageSvg;

public class LatexBuilder
implements ScientificEquation {
    private final String tex;
    private Dimension2D dimension;

    public LatexBuilder(String tex) {
        this.tex = tex;
    }

    @Override
    public Dimension2D getDimension() {
        return this.dimension;
    }

    private Icon buildIcon(Color foregroundColor) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return new TeXIconBuilder(this.tex, foregroundColor).getIcon();
    }

    @Override
    public UImageSvg getSvg(double scale, Color foregroundColor, Color backgroundColor) throws ClassNotFoundException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, InstantiationException, IOException {
        Icon icon = this.buildIcon(foregroundColor);
        ConverterSvg converterSvg = new ConverterSvg(icon);
        String svg = converterSvg.getSvg(scale, true, backgroundColor);
        this.dimension = converterSvg.getDimension();
        return new UImageSvg(svg, scale);
    }

    @Override
    public MutableImage getImage(Color foregroundColor, Color backgroundColor) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Icon icon = this.buildIcon(foregroundColor);
        return new LatexImage(icon, 1.0, foregroundColor, backgroundColor);
    }

    @Override
    public String getSource() {
        return this.tex;
    }

    class LatexImage
    implements MutableImage {
        private final double scale;
        private final Icon icon;
        private final Color foregroundColor;
        private final Color backgroundColor;
        private BufferedImage cache = null;

        public LatexImage(Icon icon, double scale, Color foregroundColor, Color backgroundColor) {
            this.scale = scale;
            this.foregroundColor = foregroundColor;
            this.backgroundColor = backgroundColor;
            this.icon = icon;
        }

        @Override
        public BufferedImage getImage() {
            if (this.cache == null) {
                this.cache = new BufferedImage((int)((double)this.icon.getIconWidth() * this.scale), (int)((double)this.icon.getIconHeight() * this.scale), 2);
                Graphics2D g2 = this.cache.createGraphics();
                g2.scale(this.scale, this.scale);
                if (this.backgroundColor != null) {
                    g2.setColor(this.backgroundColor);
                    g2.fillRect(0, 0, this.icon.getIconWidth(), this.icon.getIconHeight());
                }
                this.icon.paintIcon(null, g2, 0, 0);
            }
            return this.cache;
        }

        @Override
        public MutableImage withScale(double scale) {
            return new LatexImage(this.icon, this.scale * scale, this.foregroundColor, this.backgroundColor);
        }

        @Override
        public MutableImage muteColor(Color newColor) {
            return this;
        }

        @Override
        public MutableImage muteTransparentColor(Color newColor) {
            return this;
        }

        @Override
        public MutableImage monochrome() {
            return this;
        }
    }
}

