/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.posimo;

import java.awt.geom.Point2D;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LinkStyle;
import znaishaded.net.sourceforge.plantuml.posimo.Decor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class DecorInterfaceProvider
implements Decor {
    private final double radius = 5.0;
    private final double radius2 = 9.0;
    private final LinkStyle style;

    public DecorInterfaceProvider(LinkStyle style) {
        this.style = style;
    }

    @Override
    public void drawDecor(UGraphic ug, Point2D start, double direction) {
        double cornerX = start.getX() - 5.0;
        double cornerY = start.getY() - 5.0;
        double cornerX2 = start.getX() - 9.0 - 0.0 * Math.sin(direction * Math.PI / 180.0);
        double cornerY2 = start.getY() - 9.0 - 0.0 * Math.cos(direction * Math.PI / 180.0);
        if (direction >= 360.0) {
            direction -= 360.0;
        }
        UEllipse arc = new UEllipse(18.0, 18.0, direction + 15.0, 150.0);
        ug = ug.apply(new UStroke(1.5));
        ug.apply(new UTranslate(cornerX2, cornerY2)).draw(arc);
        ug.apply(new UTranslate(cornerX, cornerY)).draw(new UEllipse(10.0, 10.0));
    }
}

