/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.posimo;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.posimo.Positionable;
import znaishaded.net.sourceforge.plantuml.posimo.PositionableImpl;

public class PositionableUtils {
    public static Rectangle2D convert(Positionable positionable) {
        Point2D position = positionable.getPosition();
        Dimension2D size = positionable.getSize();
        return new Rectangle2D.Double(position.getX(), position.getY(), size.getWidth(), size.getHeight());
    }

    public static boolean contains(Positionable positionable, Point2D p) {
        Point2D position = positionable.getPosition();
        Dimension2D size = positionable.getSize();
        double width = size.getWidth();
        double height = size.getHeight();
        if (p.getX() < position.getX()) {
            return false;
        }
        if (p.getX() > position.getX() + width) {
            return false;
        }
        if (p.getY() < position.getY()) {
            return false;
        }
        return !(p.getY() > position.getY() + height);
    }

    public static boolean intersect(Positionable big, Positionable small) {
        Rectangle2D bigR = PositionableUtils.convert(big);
        Rectangle2D smallR = PositionableUtils.convert(small);
        return bigR.intersects(smallR);
    }

    public static Positionable addMargin(final Positionable pos, final double widthMargin, final double heightMargin) {
        return new Positionable(){

            @Override
            public Point2D getPosition() {
                Point2D p = pos.getPosition();
                return new Point2D.Double(p.getX() - widthMargin, p.getY() - heightMargin);
            }

            @Override
            public Dimension2D getSize() {
                return Dimension2DDouble.delta(pos.getSize(), 2.0 * widthMargin, 2.0 * heightMargin);
            }

            @Override
            public void moveSvek(double deltaX, double deltaY) {
                pos.moveSvek(deltaX, deltaY);
            }
        };
    }

    static Rectangle2D move(Rectangle2D rect, double dx, double dy) {
        return new Rectangle2D.Double(rect.getX() + dx, rect.getY() + dy, rect.getWidth(), rect.getHeight());
    }

    public static Point2D getCenter(Positionable p) {
        Point2D pt = p.getPosition();
        Dimension2D dim = p.getSize();
        return new Point2D.Double(pt.getX() + dim.getWidth() / 2.0, pt.getY() + dim.getHeight() / 2.0);
    }

    public static Positionable move(Positionable p, double deltaX, double deltaY) {
        Point2D pt = p.getPosition();
        Dimension2D dim = p.getSize();
        return new PositionableImpl(pt.getX() + deltaX, pt.getY() + deltaY, dim);
    }

    public static Positionable moveAwayFrom(Positionable fixe, Positionable toMove) {
        double min2;
        double deltaY;
        Point2D centerFixe = PositionableUtils.getCenter(fixe);
        Point2D centerToMove = PositionableUtils.getCenter(toMove);
        double deltaX = centerToMove.getX() - centerFixe.getX();
        if (!PositionableUtils.doesIntersectWithThisCoef(fixe, toMove, deltaX, deltaY = centerToMove.getY() - centerFixe.getY(), min2 = 0.0)) {
            throw new IllegalArgumentException();
        }
        double max = 0.1;
        while (PositionableUtils.doesIntersectWithThisCoef(fixe, toMove, deltaX, deltaY, max)) {
            max *= 2.0;
        }
        for (int i = 0; i < 5; ++i) {
            assert (PositionableUtils.doesIntersectWithThisCoef(fixe, toMove, deltaX, deltaY, min2));
            assert (!PositionableUtils.doesIntersectWithThisCoef(fixe, toMove, deltaX, deltaY, max));
            double candidat = (min2 + max) / 2.0;
            if (PositionableUtils.doesIntersectWithThisCoef(fixe, toMove, deltaX, deltaY, candidat)) {
                min2 = candidat;
                continue;
            }
            max = candidat;
        }
        double candidat = (min2 + max) / 2.0;
        return PositionableUtils.move(toMove, deltaX * candidat, deltaY * candidat);
    }

    private static boolean doesIntersectWithThisCoef(Positionable fixe, Positionable toMove, double deltaX, double deltaY, double c) {
        Positionable result = PositionableUtils.move(toMove, deltaX * c, deltaY * c);
        return PositionableUtils.intersect(fixe, result);
    }
}

