/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.preproc;

import java.io.IOException;
import znaishaded.net.sourceforge.plantuml.StringLocated;
import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.preproc.ReadLine;
import znaishaded.net.sourceforge.plantuml.utils.StartUtils;

public class UncommentReadLine
implements ReadLine {
    private static final Pattern2 unpause = MyPattern.cmpile("((?:\\W|\\<[^<>]*\\>)*)[@\\\\]unpause");
    private final ReadLine raw;
    private String headerToRemove;
    private boolean paused;

    public UncommentReadLine(ReadLine source) {
        this.raw = source;
    }

    @Override
    public StringLocated readLine() throws IOException {
        Matcher2 m22;
        StringLocated result = this.raw.readLine();
        if (result == null) {
            return null;
        }
        String tmp = StartUtils.beforeStartUml(result.getString());
        if (tmp != null) {
            this.headerToRemove = tmp;
        }
        if (this.paused && (m22 = unpause.matcher(result.getString())).find()) {
            this.headerToRemove = m22.group(1);
        }
        if (this.headerToRemove != null && this.headerToRemove.startsWith(result.getString())) {
            return new StringLocated("", result.getLocation());
        }
        if (this.headerToRemove != null && result.getString().startsWith(this.headerToRemove)) {
            return result.substring(this.headerToRemove.length(), result.getString().length());
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.raw.close();
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }
}

