/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.salt.element;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.salt.element.AbstractElement;
import znaishaded.net.sourceforge.plantuml.salt.element.Element;
import znaishaded.net.sourceforge.plantuml.salt.element.ElementText;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class ElementTabBar
extends AbstractElement {
    private final Collection<Element> tabs = new ArrayList<Element>();
    private final UFont font;
    private final ISkinSimple spriteContainer;
    private final double margin1 = 2.0;
    private final double margin2 = 3.0;
    private final double margin3 = 10.0;
    private boolean vertical = false;

    public ElementTabBar(UFont font, ISkinSimple spriteContainer) {
        this.font = font;
        this.spriteContainer = spriteContainer;
    }

    public void addTab(String tab) {
        ElementText elt = new ElementText(Arrays.asList(tab), this.font, this.spriteContainer);
        this.tabs.add(elt);
    }

    @Override
    public Dimension2D getPreferredDimension(StringBounder stringBounder, double x, double y) {
        if (this.vertical) {
            return this.getPreferredDimensionVertical(stringBounder, x, y);
        }
        return this.getPreferredDimensionHorizontal(stringBounder, x, y);
    }

    private Dimension2D getPreferredDimensionHorizontal(StringBounder stringBounder, double x, double y) {
        double w = 0.0;
        double h2 = 0.0;
        for (Element elt : this.tabs) {
            Dimension2D dim = elt.getPreferredDimension(stringBounder, x, y);
            w += dim.getWidth() + 2.0 + 3.0 + 10.0;
            h2 = Math.max(h2, dim.getHeight());
        }
        return new Dimension2DDouble(w, h2);
    }

    @Override
    public void drawU(UGraphic ug, int zIndex, Dimension2D dimToUse) {
        if (zIndex != 0) {
            return;
        }
        ug = ug.apply(this.getBlack());
        if (this.vertical) {
            this.drawUVertical(ug, 0.0, 0.0, zIndex, dimToUse);
        } else {
            this.drawUHorizontal(ug, 0.0, 0.0, zIndex, dimToUse);
        }
    }

    private void drawUHorizontal(UGraphic ug, double x, double y, int zIndex, Dimension2D dimToUse) {
        double x1 = x;
        for (Element elt : this.tabs) {
            elt.drawU(ug.apply(new UTranslate(x1 + 2.0, y)), zIndex, dimToUse);
            Dimension2D dimText = elt.getPreferredDimension(ug.getStringBounder(), x1, y);
            double w = dimText.getWidth();
            ug.apply(new UTranslate(x1, y)).draw(ULine.vline(dimText.getHeight()));
            ug.apply(new UTranslate(x1, y)).draw(ULine.hline(w + 2.0 + 3.0));
            ug.apply(new UTranslate(x1 + w + 2.0 + 3.0, y)).draw(ULine.vline(dimText.getHeight()));
            ug.apply(new UTranslate(x1 + w + 2.0 + 3.0, y + dimText.getHeight())).draw(ULine.hline(10.0));
            x1 += w + 2.0 + 3.0 + 10.0;
        }
    }

    private Dimension2D getPreferredDimensionVertical(StringBounder stringBounder, double x, double y) {
        double w = 0.0;
        double h2 = 0.0;
        for (Element elt : this.tabs) {
            Dimension2D dim = elt.getPreferredDimension(stringBounder, x, y);
            h2 += dim.getHeight() + 2.0 + 3.0 + 10.0;
            w = Math.max(w, dim.getWidth());
        }
        return new Dimension2DDouble(w, h2);
    }

    private void drawUVertical(UGraphic ug, double x, double y, int zIndex, Dimension2D dimToUse) {
        Dimension2D preferred = this.getPreferredDimension(ug.getStringBounder(), x, y);
        ug = ug.apply(new UTranslate(x, y));
        double y1 = x;
        for (Element elt : this.tabs) {
            elt.drawU(ug.apply(UTranslate.dy(y1 + 2.0)), zIndex, dimToUse);
            Dimension2D dimText = elt.getPreferredDimension(ug.getStringBounder(), x, y1);
            double h2 = dimText.getHeight();
            ug.apply(UTranslate.dy(y1)).draw(ULine.hline(preferred.getWidth()));
            ug.apply(UTranslate.dy(y1)).draw(ULine.vline(h2 + 2.0 + 3.0));
            ug.apply(UTranslate.dy(y1 + h2 + 2.0 + 3.0)).draw(ULine.hline(preferred.getWidth()));
            ug.apply(new UTranslate(preferred.getWidth(), y1 + h2 + 2.0 + 3.0)).draw(ULine.vline(10.0));
            y1 += h2 + 2.0 + 3.0 + 10.0;
        }
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
    }
}

