/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.graphic;

import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.sequencediagram.MessageExoType;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NotePosition;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.Arrow;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.ArrowComponent;
import znaishaded.net.sourceforge.plantuml.skin.ArrowConfiguration;
import znaishaded.net.sourceforge.plantuml.skin.ArrowDecoration;
import znaishaded.net.sourceforge.plantuml.skin.Context2D;
import znaishaded.net.sourceforge.plantuml.skin.rose.AbstractComponentRoseArrow;
import znaishaded.net.sourceforge.plantuml.skin.rose.Rose;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class MessageExoArrow
extends Arrow {
    private final LivingParticipantBox p;
    private final MessageExoType type;
    private final boolean shortArrow;
    private final ArrowConfiguration arrowConfiguration;

    public MessageExoArrow(double startingY, Rose skin, ArrowComponent arrow, LivingParticipantBox p, MessageExoType type, Url url, boolean shortArrow, ArrowConfiguration arrowConfiguration) {
        super(startingY, skin, arrow, url);
        this.p = p;
        this.type = type;
        this.shortArrow = shortArrow;
        this.arrowConfiguration = arrowConfiguration;
    }

    double getActualWidth(StringBounder stringBounder, double maxX) {
        double r = this.getRightEndInternal(stringBounder, maxX) - this.getLeftStartInternal(stringBounder);
        assert (r > 0.0);
        return r;
    }

    private double getLeftStartInternal(StringBounder stringBounder) {
        if (this.type == MessageExoType.FROM_LEFT || this.type == MessageExoType.TO_LEFT) {
            if (this.shortArrow) {
                return this.p.getLiveThicknessAt(stringBounder, this.getArrowYStartLevel(stringBounder)).getSegment().getPos2() - this.getPreferredWidth(stringBounder);
            }
            if (this.arrowConfiguration.getDecoration1() == ArrowDecoration.CIRCLE && this.type == MessageExoType.FROM_LEFT) {
                return 8.0;
            }
            if (this.arrowConfiguration.getDecoration2() == ArrowDecoration.CIRCLE && this.type == MessageExoType.TO_LEFT) {
                return 8.0;
            }
            return 0.0;
        }
        return this.p.getLiveThicknessAt(stringBounder, this.getArrowYStartLevel(stringBounder)).getSegment().getPos2();
    }

    private double getRightEndInternal(StringBounder stringBounder, double maxX) {
        if (this.type == MessageExoType.FROM_LEFT || this.type == MessageExoType.TO_LEFT) {
            return this.p.getLiveThicknessAt(stringBounder, this.getArrowYStartLevel(stringBounder)).getSegment().getPos1();
        }
        if (this.shortArrow) {
            return this.getLeftStartInternal(stringBounder) + this.getPreferredWidth(stringBounder);
        }
        double result = Math.max(maxX, this.getLeftStartInternal(stringBounder) + this.getPreferredWidth(stringBounder));
        if (this.arrowConfiguration.getDecoration2() == ArrowDecoration.CIRCLE && this.type == MessageExoType.TO_RIGHT) {
            result -= 8.0;
        }
        if (this.arrowConfiguration.getDecoration1() == ArrowDecoration.CIRCLE && this.type == MessageExoType.FROM_RIGHT) {
            result -= 8.0;
        }
        return result;
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getArrowComponent().getPreferredHeight(stringBounder);
    }

    @Override
    public double getStartingX(StringBounder stringBounder) {
        return this.getLeftStartInternal(stringBounder);
    }

    @Override
    public int getDirection(StringBounder stringBounder) {
        return this.type.getDirection();
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        double result = this.getArrowComponent().getPreferredWidth(stringBounder);
        if (this.arrowConfiguration.getDecoration2() == ArrowDecoration.CIRCLE && this.type == MessageExoType.TO_RIGHT) {
            result += 8.0;
        }
        if (this.arrowConfiguration.getDecoration1() == ArrowDecoration.CIRCLE && this.type == MessageExoType.FROM_RIGHT) {
            result += 8.0;
        }
        if (this.arrowConfiguration.getDecoration1() == ArrowDecoration.CIRCLE && this.type == MessageExoType.FROM_LEFT) {
            result += 8.0;
        }
        if (this.arrowConfiguration.getDecoration2() == ArrowDecoration.CIRCLE && this.type == MessageExoType.TO_LEFT) {
            result += 8.0;
        }
        return result;
    }

    @Override
    protected void drawInternalU(UGraphic ug, double maxX, Context2D context) {
        StringBounder stringBounder = ug.getStringBounder();
        double x1 = this.getStartingX(stringBounder);
        double x2 = maxX;
        ug = ug.apply(new UTranslate(x1, this.getStartingY()));
        this.startUrl(ug);
        this.getArrowComponent().drawU(ug, new Area(this.getActualDimension(stringBounder, x2)), context);
        this.endUrl(ug);
    }

    private Dimension2D getActualDimension(StringBounder stringBounder, double maxX) {
        return new Dimension2DDouble(this.getActualWidth(stringBounder, maxX), this.getArrowComponent().getPreferredHeight(stringBounder));
    }

    @Override
    public double getArrowYStartLevel(StringBounder stringBounder) {
        if (this.getArrowComponent() instanceof AbstractComponentRoseArrow) {
            AbstractComponentRoseArrow arrowComponent = (AbstractComponentRoseArrow)this.getArrowComponent();
            Dimension2DDouble dim = new Dimension2DDouble(arrowComponent.getPreferredWidth(stringBounder), arrowComponent.getPreferredHeight(stringBounder));
            return this.getStartingY() + arrowComponent.getStartPoint(stringBounder, dim).getY();
        }
        return this.getStartingY();
    }

    @Override
    public double getArrowYEndLevel(StringBounder stringBounder) {
        if (this.getArrowComponent() instanceof AbstractComponentRoseArrow) {
            AbstractComponentRoseArrow arrowComponent = (AbstractComponentRoseArrow)this.getArrowComponent();
            Dimension2DDouble dim = new Dimension2DDouble(arrowComponent.getPreferredWidth(stringBounder), arrowComponent.getPreferredHeight(stringBounder));
            return this.getStartingY() + arrowComponent.getEndPoint(stringBounder, dim).getY();
        }
        return this.getStartingY() + this.getArrowComponent().getPreferredHeight(stringBounder);
    }

    @Override
    public double getMaxX(StringBounder stringBounder) {
        return this.getRightEndInternal(stringBounder, 0.0);
    }

    @Override
    public double getMinX(StringBounder stringBounder) {
        return this.getLeftStartInternal(stringBounder);
    }

    @Override
    public String toString(StringBounder stringBounder) {
        return this.getMinX(stringBounder) + "-" + this.getMaxX(stringBounder);
    }

    public final MessageExoType getType() {
        return this.type;
    }

    @Override
    public LivingParticipantBox getParticipantAt(StringBounder stringBounder, NotePosition position) {
        return this.p;
    }

    @Override
    public double getActualWidth(StringBounder stringBounder) {
        return this.getActualWidth(stringBounder, this.getMaxX());
    }
}

