/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.graphic;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import znaishaded.net.sourceforge.plantuml.FileFormat;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.api.ImageDataSimple;
import znaishaded.net.sourceforge.plantuml.asciiart.TextSkin;
import znaishaded.net.sourceforge.plantuml.asciiart.TextStringBounder;
import znaishaded.net.sourceforge.plantuml.asciiart.UmlCharArea;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.core.ImageData;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.security.SecurityUtils;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Event;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Participant;
import znaishaded.net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.DrawableSet;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.DrawableSetInitializer;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.FileMaker;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.Page;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

public class SequenceDiagramTxtMaker
implements FileMaker {
    private final SequenceDiagram diagram;
    private final DrawableSet drawableSet;
    private final Dimension2D fullDimension;
    private final StringBounder dummyStringBounder = new TextStringBounder();
    private final UGraphicTxt ug = new UGraphicTxt();
    private final FileFormat fileFormat;
    private final TextSkin skin;

    public SequenceDiagramTxtMaker(SequenceDiagram sequenceDiagram, FileFormat fileFormat) {
        this.fileFormat = fileFormat;
        this.diagram = sequenceDiagram;
        this.skin = new TextSkin(fileFormat);
        DrawableSetInitializer initializer = new DrawableSetInitializer(this.skin, sequenceDiagram.getSkinParam(), sequenceDiagram.isShowFootbox(), sequenceDiagram.getAutonewpage());
        for (Participant p : sequenceDiagram.participants()) {
            initializer.addParticipant(p, null);
        }
        for (Event ev : sequenceDiagram.events()) {
            initializer.addEvent(ev);
        }
        this.drawableSet = initializer.createDrawableSet(this.dummyStringBounder);
        this.fullDimension = this.drawableSet.getDimension();
        double headerHeight = this.drawableSet.getHeadHeight(this.dummyStringBounder);
        double tailHeight = this.drawableSet.getTailHeight(this.dummyStringBounder, this.diagram.isShowFootbox());
        double newpage2 = this.fullDimension.getHeight() - (this.diagram.isShowFootbox() ? tailHeight : 0.0) - headerHeight;
        Page page = new Page(headerHeight, 0.0, newpage2, tailHeight, 0.0, null);
        Display title = this.diagram.getTitle().getDisplay();
        UGraphicTxt ug2 = title.isWhite() ? this.ug : (UGraphicTxt)this.ug.apply(UTranslate.dy(title.asList().size() + 1));
        this.drawableSet.drawU22(ug2, 0.0, this.fullDimension.getWidth(), page, this.diagram.isShowFootbox());
        if (!title.isWhite()) {
            int widthTitle = StringUtils.getWcWidth(title);
            UmlCharArea charArea = this.ug.getCharArea();
            charArea.drawStringsLRSimple(title.asList(), (int)((this.fullDimension.getWidth() - (double)widthTitle) / 2.0), 0);
        }
    }

    @Override
    public ImageData createOne(OutputStream os, int index, boolean isWithMetadata) throws IOException {
        if (this.fileFormat == FileFormat.UTXT) {
            PrintStream ps = SecurityUtils.createPrintStream(os, true, StandardCharsets.UTF_8);
            this.ug.getCharArea().print(ps);
        } else {
            PrintStream ps = SecurityUtils.createPrintStream(os);
            this.ug.getCharArea().print(ps);
        }
        return new ImageDataSimple(1, 1);
    }

    @Override
    public int getNbPages() {
        return 1;
    }
}

