/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Point2D;
import java.util.Iterator;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.real.Real;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Event;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Message;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.AbstractTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.EventsHistoryMode;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.LivingSpaces;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.ArrowComponent;
import znaishaded.net.sourceforge.plantuml.skin.ArrowConfiguration;
import znaishaded.net.sourceforge.plantuml.skin.Context2D;
import znaishaded.net.sourceforge.plantuml.skin.rose.Rose;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class CommunicationTileSelf
extends AbstractTile {
    private final LivingSpace livingSpace1;
    private final Message message;
    private final Rose skin;
    private final ISkinParam skinParam;
    private final LivingSpaces livingSpaces;

    @Override
    public Event getEvent() {
        return this.message;
    }

    @Override
    public double getContactPointRelative() {
        return this.getComponent(this.getStringBounder()).getYPoint(this.getStringBounder());
    }

    public CommunicationTileSelf(StringBounder stringBounder, LivingSpace livingSpace1, Message message, Rose skin, ISkinParam skinParam, LivingSpaces livingSpaces) {
        super(stringBounder);
        this.livingSpace1 = livingSpace1;
        this.livingSpaces = livingSpaces;
        this.message = message;
        this.skin = skin;
        this.skinParam = skinParam;
    }

    private ArrowComponent getComponent(StringBounder stringBounder) {
        ArrowConfiguration arrowConfiguration = this.message.getArrowConfiguration();
        arrowConfiguration = arrowConfiguration.self();
        ArrowComponent comp = this.skin.createComponentArrow(this.message.getUsedStyles(), arrowConfiguration, this.skinParam, this.message.getLabelNumbered());
        return comp;
    }

    @Override
    protected final void callbackY_internal(double y) {
        ArrowComponent comp = this.getComponent(this.getStringBounder());
        Dimension2D dim = comp.getPreferredDimension(this.getStringBounder());
        Point2D p1 = comp.getStartPoint(this.getStringBounder(), dim);
        Point2D p2 = comp.getEndPoint(this.getStringBounder(), dim);
        if (this.message.isActivate()) {
            this.livingSpace1.addStepForLivebox(this.getEvent(), y + p2.getY());
        } else if (this.message.isDeactivate()) {
            this.livingSpace1.addStepForLivebox(this.getEvent(), y + p1.getY());
        } else if (this.message.isDestroy()) {
            this.livingSpace1.addStepForLivebox(this.getEvent(), y + p2.getY());
        }
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        ArrowComponent comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        double x1 = this.getPoint1(stringBounder).getCurrentValue();
        int levelIgnore = this.livingSpace1.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_ACTIVATE);
        int levelConsidere = this.livingSpace1.getLevelAt(this, EventsHistoryMode.CONSIDERE_FUTURE_DEACTIVATE);
        Log.info("CommunicationTileSelf::drawU levelIgnore=" + levelIgnore + " levelConsidere=" + levelConsidere);
        x1 += 5.0 * (double)levelIgnore;
        if (levelIgnore < levelConsidere) {
            x1 += 5.0;
        }
        Area area = Area.create(dim.getWidth(), dim.getHeight());
        area.setDeltaX1((double)(levelIgnore - levelConsidere) * 5.0);
        ug = ug.apply(UTranslate.dx(x1));
        comp.drawU(ug, area, (Context2D)((Object)ug));
    }

    @Override
    public double getPreferredHeight() {
        ArrowComponent comp = this.getComponent(this.getStringBounder());
        Dimension2D dim = comp.getPreferredDimension(this.getStringBounder());
        return dim.getHeight();
    }

    @Override
    public void addConstraints() {
        if (this.isReverseDefine()) {
            LivingSpace previous = this.getPrevious();
            if (previous != null) {
                this.livingSpace1.getPosC(this.getStringBounder()).ensureBiggerThan(previous.getPosC(this.getStringBounder()).addFixed(this.getCompWidth()));
            }
        } else {
            LivingSpace next = this.getNext();
            if (next != null) {
                next.getPosC(this.getStringBounder()).ensureBiggerThan(this.getMaxX());
            }
        }
    }

    private boolean isReverseDefine() {
        return this.message.getArrowConfiguration().isReverseDefine();
    }

    private LivingSpace getPrevious() {
        LivingSpace previous = null;
        for (LivingSpace current : this.livingSpaces.values()) {
            if (current == this.livingSpace1) {
                return previous;
            }
            previous = current;
        }
        return null;
    }

    private LivingSpace getNext() {
        Iterator<LivingSpace> it = this.livingSpaces.values().iterator();
        while (it.hasNext()) {
            LivingSpace current = it.next();
            if (current != this.livingSpace1 || !it.hasNext()) continue;
            return it.next();
        }
        return null;
    }

    private Real getPoint1(StringBounder stringBounder) {
        return this.livingSpace1.getPosC(stringBounder);
    }

    @Override
    public Real getMinX() {
        if (this.isReverseDefine()) {
            return this.getPoint1(this.getStringBounder());
        }
        return this.getPoint1(this.getStringBounder());
    }

    @Override
    public Real getMaxX() {
        if (this.isReverseDefine()) {
            return this.livingSpace1.getPosC2(this.getStringBounder());
        }
        return this.livingSpace1.getPosC2(this.getStringBounder()).addFixed(this.getCompWidth());
    }

    private double getCompWidth() {
        ArrowComponent comp = this.getComponent(this.getStringBounder());
        return comp.getPreferredDimension(this.getStringBounder()).getWidth();
    }
}

