/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.skin;

import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.UDrawable;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class CircleInterface
implements UDrawable {
    private final float thickness;
    private final double headDiam;
    private final HColor backgroundColor;
    private final HColor foregroundColor;

    public CircleInterface(HColor backgroundColor, HColor foregroundColor, double headDiam, float thickness) {
        this.backgroundColor = backgroundColor;
        this.foregroundColor = foregroundColor;
        this.headDiam = headDiam;
        this.thickness = thickness;
    }

    @Override
    public void drawU(UGraphic ug) {
        UEllipse head = new UEllipse(this.headDiam, this.headDiam);
        ug.apply(new UStroke(this.thickness)).apply(this.backgroundColor.bg()).apply(this.foregroundColor).apply(new UTranslate(this.thickness, this.thickness)).draw(head);
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return this.headDiam + (double)(2.0f * this.thickness);
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return this.headDiam + (double)(2.0f * this.thickness);
    }
}

