/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.skin.rose;

import znaishaded.net.sourceforge.plantuml.api.ThemeStyle;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.skin.AbstractComponent;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorSet;

public class ComponentRoseLine
extends AbstractComponent {
    private final HColor color;
    private final boolean continueLine;
    private final UStroke stroke;

    public ComponentRoseLine(ThemeStyle themeStyle, Style style, boolean continueLine, HColorSet set) {
        super(style);
        this.color = style.value(PName.LineColor).asColor(themeStyle, set);
        this.stroke = style.getStroke();
        this.continueLine = continueLine;
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        Dimension2D dimensionToUse = area.getDimensionToUse();
        ug = ug.apply(this.color);
        ug = ug.apply(this.stroke);
        int x = (int)(dimensionToUse.getWidth() / 2.0);
        ug.apply(UTranslate.dx(x)).draw(ULine.vline(dimensionToUse.getHeight()));
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return 20.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return 1.0;
    }
}

