/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.skin.rose;

import znaishaded.net.sourceforge.plantuml.AlignmentParam;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.LineParam;
import znaishaded.net.sourceforge.plantuml.PaddingParam;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NotePosition;
import znaishaded.net.sourceforge.plantuml.skin.ArrowComponent;
import znaishaded.net.sourceforge.plantuml.skin.ArrowConfiguration;
import znaishaded.net.sourceforge.plantuml.skin.ArrowDirection;
import znaishaded.net.sourceforge.plantuml.skin.Component;
import znaishaded.net.sourceforge.plantuml.skin.ComponentType;
import znaishaded.net.sourceforge.plantuml.skin.rose.ComponentRoseActiveLine;
import znaishaded.net.sourceforge.plantuml.skin.rose.ComponentRoseActor;
import znaishaded.net.sourceforge.plantuml.skin.rose.ComponentRoseArrow;
import znaishaded.net.sourceforge.plantuml.skin.rose.ComponentRoseBoundary;
import znaishaded.net.sourceforge.plantuml.skin.rose.ComponentRoseControl;
import znaishaded.net.sourceforge.plantuml.skin.rose.ComponentRoseDatabase;
import znaishaded.net.sourceforge.plantuml.skin.rose.ComponentRoseDelayLine;
import znaishaded.net.sourceforge.plantuml.skin.rose.ComponentRoseDelayText;
import znaishaded.net.sourceforge.plantuml.skin.rose.ComponentRoseDestroy;
import znaishaded.net.sourceforge.plantuml.skin.rose.ComponentRoseDivider;
import znaishaded.net.sourceforge.plantuml.skin.rose.ComponentRoseEnglober;
import znaishaded.net.sourceforge.plantuml.skin.rose.ComponentRoseEntity;
import znaishaded.net.sourceforge.plantuml.skin.rose.ComponentRoseGroupingElse;
import znaishaded.net.sourceforge.plantuml.skin.rose.ComponentRoseGroupingHeader;
import znaishaded.net.sourceforge.plantuml.skin.rose.ComponentRoseGroupingSpace;
import znaishaded.net.sourceforge.plantuml.skin.rose.ComponentRoseLine;
import znaishaded.net.sourceforge.plantuml.skin.rose.ComponentRoseNewpage;
import znaishaded.net.sourceforge.plantuml.skin.rose.ComponentRoseNote;
import znaishaded.net.sourceforge.plantuml.skin.rose.ComponentRoseNoteBox;
import znaishaded.net.sourceforge.plantuml.skin.rose.ComponentRoseNoteHexagonal;
import znaishaded.net.sourceforge.plantuml.skin.rose.ComponentRoseParticipant;
import znaishaded.net.sourceforge.plantuml.skin.rose.ComponentRoseQueue;
import znaishaded.net.sourceforge.plantuml.skin.rose.ComponentRoseReference;
import znaishaded.net.sourceforge.plantuml.skin.rose.ComponentRoseSelfArrow;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class Rose {
    private final double paddingX = 5.0;
    public static final double paddingY = 5.0;

    public HColor getFontColor(ISkinParam skin, FontParam fontParam) {
        return skin.getFontHtmlColor(null, fontParam);
    }

    public HColor getHtmlColor(ISkinParam skin, ColorParam color) {
        return this.getHtmlColor(skin, null, color);
    }

    public HColor getHtmlColor(ISkinParam skin, Stereotype stereotype, ColorParam ... colorParams) {
        for (ColorParam param : colorParams) {
            HColor result = skin.getHtmlColor(param, stereotype, false);
            if (result == null) continue;
            return result;
        }
        return colorParams[0].getDefaultValue();
    }

    public Component createComponentNote(Style[] styles, ComponentType type, ISkinParam param, Display stringsToDisplay) {
        this.checkRose();
        return this.createComponentNote(styles, type, param, stringsToDisplay, null);
    }

    private void checkRose() {
        if (this.getClass() != Rose.class) {
            throw new IllegalStateException("" + this.getClass());
        }
    }

    public Component createComponentNote(Style[] styles, ComponentType type, ISkinParam param, Display stringsToDisplay, NotePosition notePosition) {
        HorizontalAlignment textAlign;
        this.checkRose();
        HorizontalAlignment position = notePosition == NotePosition.OVER_SEVERAL ? ((textAlign = param.getHorizontalAlignment(AlignmentParam.noteTextAlignment, null, false, HorizontalAlignment.LEFT)) == param.getHorizontalAlignment(AlignmentParam.noteTextAlignment, null, false, HorizontalAlignment.CENTER) ? textAlign : HorizontalAlignment.CENTER) : (textAlign = param.getHorizontalAlignment(AlignmentParam.noteTextAlignment, null, false, null));
        if (type == ComponentType.NOTE) {
            return new ComponentRoseNote(styles == null ? null : styles[0], stringsToDisplay, 5.0, 5.0, param, textAlign, position);
        }
        if (type == ComponentType.NOTE_HEXAGONAL) {
            return new ComponentRoseNoteHexagonal(styles == null ? null : styles[0], stringsToDisplay, param);
        }
        if (type == ComponentType.NOTE_BOX) {
            return new ComponentRoseNoteBox(styles == null ? null : styles[0], stringsToDisplay, param);
        }
        throw new UnsupportedOperationException(type.toString());
    }

    public Component createComponent(Style[] styles, ComponentType type, ArrowConfiguration config, ISkinParam param, Display stringsToDisplay) {
        Stereotype stereotype;
        this.checkRose();
        Stereotype stereotype2 = stereotype = stringsToDisplay == null ? null : stringsToDisplay.getStereotypeIfAny();
        if (type.isArrow()) {
            return this.createComponentArrow(null, config, param, stringsToDisplay);
        }
        double padding = param.getPadding(PaddingParam.PARTICIPANT);
        if (type == ComponentType.PARTICIPANT_HEAD) {
            return new ComponentRoseParticipant(styles == null ? null : styles[0], styles == null ? null : styles[1], stringsToDisplay, param, param.minClassWidth(), false, padding);
        }
        if (type == ComponentType.PARTICIPANT_TAIL) {
            return new ComponentRoseParticipant(styles == null ? null : styles[0], styles == null ? null : styles[1], stringsToDisplay, param, param.minClassWidth(), false, padding);
        }
        if (type == ComponentType.COLLECTIONS_HEAD) {
            return new ComponentRoseParticipant(styles == null ? null : styles[0], styles == null ? null : styles[1], stringsToDisplay, param, param.minClassWidth(), true, padding);
        }
        if (type == ComponentType.COLLECTIONS_TAIL) {
            return new ComponentRoseParticipant(styles == null ? null : styles[0], styles == null ? null : styles[1], stringsToDisplay, param, param.minClassWidth(), true, padding);
        }
        if (type == ComponentType.PARTICIPANT_LINE) {
            return new ComponentRoseLine(param.getThemeStyle(), styles == null ? null : styles[0], false, param.getIHtmlColorSet());
        }
        if (type == ComponentType.CONTINUE_LINE) {
            return new ComponentRoseLine(param.getThemeStyle(), styles == null ? null : styles[0], true, param.getIHtmlColorSet());
        }
        if (type == ComponentType.ACTOR_HEAD) {
            return new ComponentRoseActor(param.actorStyle(), styles == null ? null : styles[0], styles == null ? null : styles[1], stringsToDisplay, true, param);
        }
        if (type == ComponentType.ACTOR_TAIL) {
            return new ComponentRoseActor(param.actorStyle(), styles == null ? null : styles[0], styles == null ? null : styles[1], stringsToDisplay, false, param);
        }
        if (type == ComponentType.BOUNDARY_HEAD) {
            return new ComponentRoseBoundary(styles == null ? null : styles[0], styles == null ? null : styles[1], stringsToDisplay, true, param);
        }
        if (type == ComponentType.BOUNDARY_TAIL) {
            return new ComponentRoseBoundary(styles == null ? null : styles[0], styles == null ? null : styles[1], stringsToDisplay, false, param);
        }
        if (type == ComponentType.CONTROL_HEAD) {
            return new ComponentRoseControl(styles == null ? null : styles[0], styles == null ? null : styles[1], stringsToDisplay, true, param);
        }
        if (type == ComponentType.CONTROL_TAIL) {
            return new ComponentRoseControl(styles == null ? null : styles[0], styles == null ? null : styles[1], stringsToDisplay, false, param);
        }
        if (type == ComponentType.ENTITY_HEAD) {
            return new ComponentRoseEntity(styles == null ? null : styles[0], styles == null ? null : styles[1], stringsToDisplay, true, param);
        }
        if (type == ComponentType.ENTITY_TAIL) {
            return new ComponentRoseEntity(styles == null ? null : styles[0], styles == null ? null : styles[1], stringsToDisplay, false, param);
        }
        if (type == ComponentType.QUEUE_HEAD) {
            return new ComponentRoseQueue(styles == null ? null : styles[0], styles == null ? null : styles[1], stringsToDisplay, true, param);
        }
        if (type == ComponentType.QUEUE_TAIL) {
            return new ComponentRoseQueue(styles == null ? null : styles[0], styles == null ? null : styles[1], stringsToDisplay, false, param);
        }
        if (type == ComponentType.DATABASE_HEAD) {
            return new ComponentRoseDatabase(styles == null ? null : styles[0], styles == null ? null : styles[1], stringsToDisplay, true, param);
        }
        if (type == ComponentType.DATABASE_TAIL) {
            return new ComponentRoseDatabase(styles == null ? null : styles[0], styles == null ? null : styles[1], stringsToDisplay, false, param);
        }
        if (type == ComponentType.NOTE) {
            throw new UnsupportedOperationException();
        }
        if (type == ComponentType.NOTE_HEXAGONAL) {
            throw new UnsupportedOperationException();
        }
        if (type == ComponentType.NOTE_BOX) {
            throw new UnsupportedOperationException();
        }
        if (type == ComponentType.GROUPING_HEADER) {
            return new ComponentRoseGroupingHeader(styles == null ? null : styles[0], styles == null ? null : styles[1], stringsToDisplay, param);
        }
        if (type == ComponentType.GROUPING_ELSE) {
            return new ComponentRoseGroupingElse(styles == null ? null : styles[0], stringsToDisplay.get(0), param);
        }
        if (type == ComponentType.GROUPING_SPACE) {
            return new ComponentRoseGroupingSpace(7.0);
        }
        if (type == ComponentType.ALIVE_BOX_CLOSE_CLOSE) {
            return new ComponentRoseActiveLine(param.getThemeStyle(), styles == null ? null : styles[0], true, true, param.getIHtmlColorSet());
        }
        if (type == ComponentType.ALIVE_BOX_CLOSE_OPEN) {
            return new ComponentRoseActiveLine(param.getThemeStyle(), styles == null ? null : styles[0], true, false, param.getIHtmlColorSet());
        }
        if (type == ComponentType.ALIVE_BOX_OPEN_CLOSE) {
            return new ComponentRoseActiveLine(param.getThemeStyle(), styles == null ? null : styles[0], false, true, param.getIHtmlColorSet());
        }
        if (type == ComponentType.ALIVE_BOX_OPEN_OPEN) {
            return new ComponentRoseActiveLine(param.getThemeStyle(), styles == null ? null : styles[0], false, false, param.getIHtmlColorSet());
        }
        if (type == ComponentType.DELAY_LINE) {
            return new ComponentRoseDelayLine(null, this.getHtmlColor(param, stereotype, ColorParam.sequenceLifeLineBorder));
        }
        if (type == ComponentType.DELAY_TEXT) {
            return new ComponentRoseDelayText(styles == null ? null : styles[0], stringsToDisplay, param);
        }
        if (type == ComponentType.DESTROY) {
            return new ComponentRoseDestroy(styles == null ? null : styles[0], this.getHtmlColor(param, stereotype, ColorParam.sequenceLifeLineBorder), param);
        }
        if (type == ComponentType.NEWPAGE) {
            throw new UnsupportedOperationException();
        }
        if (type == ComponentType.DIVIDER) {
            return new ComponentRoseDivider(styles == null ? null : styles[0], stringsToDisplay, param);
        }
        if (type == ComponentType.REFERENCE) {
            return new ComponentRoseReference(styles == null ? null : styles[0], styles == null ? null : styles[1], stringsToDisplay, param, this.getHtmlColor(param, stereotype, ColorParam.sequenceReferenceBackground));
        }
        if (type == ComponentType.ENGLOBER) {
            return new ComponentRoseEnglober(styles == null ? null : styles[0], stringsToDisplay, param);
        }
        throw new UnsupportedOperationException();
    }

    public Component createComponentNewPage(ISkinParam param) {
        this.checkRose();
        return new ComponentRoseNewpage(null, this.getHtmlColor(param, ColorParam.sequenceNewpageSeparator));
    }

    public ArrowComponent createComponentArrow(Style[] styles, ArrowConfiguration config, ISkinParam param, Display stringsToDisplay) {
        this.checkRose();
        if (config.getArrowDirection() == ArrowDirection.SELF) {
            return new ComponentRoseSelfArrow(styles == null ? null : styles[0], stringsToDisplay, config, param, param.maxMessageSize(), !param.strictUmlStyle());
        }
        ArrowDirection arrowDirection = config.getArrowDirection();
        StyleSignatureBasic signature = StyleSignatureBasic.of(SName.root, SName.element, SName.sequenceDiagram, SName.arrow);
        Style textStyle = signature.getMergedStyle(param.getCurrentStyleBuilder());
        String value = textStyle.value(PName.HorizontalAlignment).asString();
        HorizontalAlignment messageHorizontalAlignment = textStyle.getHorizontalAlignment();
        if ("first".equalsIgnoreCase(value)) {
            boolean isReverseDefine = config.isReverseDefine();
            messageHorizontalAlignment = arrowDirection == ArrowDirection.RIGHT_TO_LEFT_REVERSE ? (isReverseDefine ? HorizontalAlignment.LEFT : HorizontalAlignment.RIGHT) : (isReverseDefine ? HorizontalAlignment.RIGHT : HorizontalAlignment.LEFT);
        } else if ("direction".equalsIgnoreCase(value)) {
            if (arrowDirection == ArrowDirection.LEFT_TO_RIGHT_NORMAL) {
                messageHorizontalAlignment = HorizontalAlignment.LEFT;
            } else if (arrowDirection == ArrowDirection.RIGHT_TO_LEFT_REVERSE) {
                messageHorizontalAlignment = HorizontalAlignment.RIGHT;
            } else if (arrowDirection == ArrowDirection.BOTH_DIRECTION) {
                messageHorizontalAlignment = HorizontalAlignment.CENTER;
            }
        } else if ("reversedirection".equalsIgnoreCase(value)) {
            if (arrowDirection == ArrowDirection.LEFT_TO_RIGHT_NORMAL) {
                messageHorizontalAlignment = HorizontalAlignment.RIGHT;
            } else if (arrowDirection == ArrowDirection.RIGHT_TO_LEFT_REVERSE) {
                messageHorizontalAlignment = HorizontalAlignment.LEFT;
            } else if (arrowDirection == ArrowDirection.BOTH_DIRECTION) {
                messageHorizontalAlignment = HorizontalAlignment.CENTER;
            }
        }
        return new ComponentRoseArrow(styles == null ? null : styles[0], stringsToDisplay, config, messageHorizontalAlignment, param, param.maxMessageSize(), !param.strictUmlStyle(), param.responseMessageBelowArrow());
    }

    public static UStroke getStroke(ISkinParam param, LineParam lineParam, double defaultValue) {
        UStroke result = param.getThickness(lineParam, null);
        if (result == null) {
            return new UStroke(defaultValue);
        }
        return result;
    }
}

