/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sprite;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.UmlDiagram;
import znaishaded.net.sourceforge.plantuml.UmlDiagramType;
import znaishaded.net.sourceforge.plantuml.WithSprite;
import znaishaded.net.sourceforge.plantuml.api.ThemeStyle;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.command.BlocLines;
import znaishaded.net.sourceforge.plantuml.command.Command;
import znaishaded.net.sourceforge.plantuml.command.CommandFactorySprite;
import znaishaded.net.sourceforge.plantuml.core.DiagramDescription;
import znaishaded.net.sourceforge.plantuml.core.ImageData;
import znaishaded.net.sourceforge.plantuml.core.UmlSource;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.preproc.Stdlib;
import znaishaded.net.sourceforge.plantuml.sprite.Sprite;
import znaishaded.net.sourceforge.plantuml.ugraphic.ImageBuilder;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public class StdlibDiagram
extends UmlDiagram {
    private static final int WIDTH = 1800;
    private String name;

    public StdlibDiagram(ThemeStyle style, UmlSource source, ISkinSimple skinParam) {
        super(style, source, UmlDiagramType.HELP, skinParam);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Sprites)");
    }

    @Override
    public ImageBuilder createImageBuilder(FileFormatOption fileFormatOption) throws IOException {
        return super.createImageBuilder(fileFormatOption).annotations(false);
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        return this.createImageBuilder(fileFormatOption).drawable(this.getTable()).write(os);
    }

    private TextBlock getTable() {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                try {
                    StdlibDiagram.this.drawInternal(ug);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(1800.0, 4096.0);
            }
        };
    }

    public void setStdlibName(String name) {
        this.name = name;
    }

    private void drawInternal(UGraphic ug) throws IOException {
        double x = 0.0;
        double y = 0.0;
        double rawHeight = 0.0;
        Stdlib folder = Stdlib.retrieve(this.name);
        CommandFactorySprite factorySpriteCommand = new CommandFactorySprite();
        Command<WithSprite> cmd = factorySpriteCommand.createMultiLine(false);
        List<String> all = folder.extractAllSprites();
        int nb = 0;
        for (String s2 : all) {
            BlocLines bloc = BlocLines.fromArray(s2.split("\n"));
            try {
                cmd.execute(this, bloc);
            }
            catch (NoSuchColorException e) {
                e.printStackTrace();
            }
            ++nb;
        }
        for (String n : this.getSkinParam().getAllSpriteNames()) {
            Sprite sprite = this.getSkinParam().getSprite(n);
            TextBlock blockName = Display.create(n).create(FontConfiguration.blackBlueTrue(UFont.sansSerif(14)), HorizontalAlignment.LEFT, this.getSkinParam());
            TextBlock tb = sprite.asTextBlock(this.getBlack(), 1.0, this.getSkinParam().getColorMapper());
            tb = TextBlockUtils.mergeTB(tb, blockName, HorizontalAlignment.CENTER);
            tb.drawU(ug.apply(new UTranslate(x, y)));
            Dimension2D dim = tb.calculateDimension(ug.getStringBounder());
            rawHeight = Math.max(rawHeight, dim.getHeight());
            x += dim.getWidth();
            if (!((x += 30.0) > 1800.0)) continue;
            x = 0.0;
            y += rawHeight + 50.0;
            rawHeight = 0.0;
            if (!(y > 1024.0)) continue;
        }
    }

    private HColor getBlack() {
        return HColorUtils.BLACK.withDark(HColorUtils.WHITE);
    }
}

