/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.stats;

import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import znaishaded.net.sourceforge.plantuml.FileFormat;
import znaishaded.net.sourceforge.plantuml.api.NumberAnalyzed;
import znaishaded.net.sourceforge.plantuml.stats.StatsLineImpl;
import znaishaded.net.sourceforge.plantuml.stats.StatsTableImpl;
import znaishaded.net.sourceforge.plantuml.stats.api.StatsColumn;
import znaishaded.net.sourceforge.plantuml.stats.api.StatsLine;
import znaishaded.net.sourceforge.plantuml.stats.api.StatsTable;

public class FormatCounter {
    private ConcurrentMap<FileFormat, NumberAnalyzed> data = new ConcurrentHashMap<FileFormat, NumberAnalyzed>();

    public FormatCounter(String prefix) {
        for (FileFormat format : FileFormat.values()) {
            String key = prefix + format.name();
            this.data.put(format, new NumberAnalyzed(key));
        }
    }

    public void plusOne(FileFormat fileFormat, long duration) {
        NumberAnalyzed n = (NumberAnalyzed)this.data.get((Object)fileFormat);
        n.addValue(duration);
    }

    private StatsLine createLine(String name, NumberAnalyzed n) {
        EnumMap<StatsColumn, Object> result = new EnumMap<StatsColumn, Object>(StatsColumn.class);
        result.put(StatsColumn.FORMAT, name);
        result.put(StatsColumn.GENERATED_COUNT, Long.valueOf(n.getNb()));
        result.put(StatsColumn.GENERATED_MEAN_TIME, Long.valueOf(n.getMean()));
        result.put(StatsColumn.GENERATED_STANDARD_DEVIATION, Long.valueOf(n.getStandardDeviation()));
        result.put(StatsColumn.GENERATED_MAX_TIME, Long.valueOf(n.getMax()));
        return new StatsLineImpl(result);
    }

    public StatsTable getStatsTable(String name) {
        StatsTableImpl result = new StatsTableImpl(name);
        NumberAnalyzed total = new NumberAnalyzed();
        for (Map.Entry ent : this.data.entrySet()) {
            NumberAnalyzed n = (NumberAnalyzed)ent.getValue();
            if (n.getNb() <= 0L) continue;
            result.addLine(this.createLine(((FileFormat)((Object)ent.getKey())).name(), n));
            total.add(n);
        }
        result.addLine(this.createLine("Total", total));
        return result;
    }

    public void reload(String prefix, Preferences prefs) throws BackingStoreException {
        for (String key : prefs.keys()) {
            if (!key.startsWith(prefix)) continue;
            try {
                String name = FormatCounter.removeDotSaved(key);
                NumberAnalyzed value = NumberAnalyzed.load(name, prefs);
                if (value == null) continue;
                FileFormat format = FileFormat.valueOf(name.substring(prefix.length()));
                this.data.put(format, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static String removeDotSaved(String key) {
        return key.substring(0, key.length() - ".saved".length());
    }

    public void save(Preferences prefs, FileFormat fileFormat) {
        ((NumberAnalyzed)this.data.get((Object)fileFormat)).save(prefs);
    }
}

