/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.style;

import java.io.IOException;
import java.io.InputStream;
import znaishaded.net.sourceforge.plantuml.FileSystem;
import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.TitledDiagram;
import znaishaded.net.sourceforge.plantuml.command.BlocLines;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.security.SFile;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleBuilder;
import znaishaded.net.sourceforge.plantuml.style.StyleLoader;

public class CommandStyleImport
extends SingleLineCommand2<TitledDiagram> {
    public CommandStyleImport() {
        super(CommandStyleImport.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandStyleImport.class.getName(), RegexLeaf.start(), new RegexLeaf("\\<style"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\w+"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("="), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("[%q%g]?"), new RegexLeaf("PATH", "([^%q%g]*)"), new RegexLeaf("[%q%g]?"), new RegexLeaf("\\>"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(TitledDiagram diagram, LineLocation location, RegexResult arg) {
        String path = arg.get("PATH", 0);
        try {
            SFile f = FileSystem.getInstance().getFile(path);
            BlocLines lines = null;
            if (f.exists()) {
                lines = BlocLines.load(f, location);
            } else {
                InputStream internalIs = StyleLoader.class.getResourceAsStream("/skin/" + path);
                if (internalIs != null) {
                    lines = BlocLines.load(internalIs, location);
                }
            }
            if (lines == null) {
                return CommandExecutionResult.error("Cannot read: " + path);
            }
            StyleBuilder styleBuilder = diagram.getSkinParam().getCurrentStyleBuilder();
            for (Style modifiedStyle : StyleLoader.getDeclaredStyles(lines, styleBuilder)) {
                diagram.getSkinParam().muteStyle(modifiedStyle);
            }
        }
        catch (IOException e) {
            return CommandExecutionResult.error("Cannot read: " + path);
        }
        return CommandExecutionResult.ok();
    }
}

