/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import znaishaded.net.sourceforge.plantuml.SignatureUtils;
import znaishaded.net.sourceforge.plantuml.svek.PortGeometry;

public class Ports {
    private final Map<String, PortGeometry> ids = new HashMap<String, PortGeometry>();

    public static String encodePortNameToId(String portName) {
        return "p" + SignatureUtils.getMD5Hex(portName);
    }

    public String toString() {
        return this.ids.toString();
    }

    public Ports translateY(double deltaY) {
        Ports result = new Ports();
        for (Map.Entry<String, PortGeometry> ent : this.ids.entrySet()) {
            result.ids.put(ent.getKey(), ent.getValue().translateY(deltaY));
        }
        return result;
    }

    public void add(String portName, int score, double position, double height) {
        String id = Ports.encodePortNameToId(Objects.requireNonNull(portName));
        PortGeometry already = this.ids.get(id);
        if (already == null || already.getScore() < score) {
            this.ids.put(id, new PortGeometry(id, position, height, score));
        }
    }

    public void addThis(Ports other) {
        for (Map.Entry<String, PortGeometry> ent : other.ids.entrySet()) {
            String key = ent.getKey();
            PortGeometry already = this.ids.get(key);
            if (already != null && already.getScore() >= ent.getValue().getScore()) continue;
            this.ids.put(key, ent.getValue());
        }
    }

    public Collection<PortGeometry> getAllPortGeometry() {
        ArrayList<PortGeometry> result = new ArrayList<PortGeometry>(this.ids.values());
        Collections.sort(result);
        return Collections.unmodifiableCollection(result);
    }
}

