/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.image;

import znaishaded.net.sourceforge.plantuml.AlignmentParam;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.Guillemet;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.EntityImageLegend;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.DisplayPositioned;
import znaishaded.net.sourceforge.plantuml.cucadiagram.EntityPortion;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.PortionShower;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.cucadiagram.entity.EntityImpl;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.graphic.color.Colors;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignature;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.svek.AbstractEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.ClusterDecoration;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class EntityImageEmptyPackage
extends AbstractEntityImage {
    private final TextBlock desc;
    private static final int MARGIN = 10;
    private final Stereotype stereotype;
    private final TextBlock stereoBlock;
    private final Url url;
    private final SName sname;
    private final double shadowing;
    private final HColor borderColor;
    private final UStroke stroke;
    private final double roundCorner;
    private final double diagonalCorner;
    private final HColor back;

    private Style getStyle() {
        return this.getStyleSignature().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
    }

    private StyleSignature getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, this.sname, SName.package_).withTOBECHANGED(this.stereotype);
    }

    public EntityImageEmptyPackage(ILeaf entity, ISkinParam skinParam, PortionShower portionShower, SName sname) {
        super(entity, skinParam);
        TextBlock legendBlock;
        this.sname = sname;
        Colors colors = entity.getColors();
        HColor specificBackColor = colors.getColor(ColorType.BACK);
        this.stereotype = entity.getStereotype();
        this.url = entity.getUrl99();
        Style style = this.getStyle();
        style = style.eventuallyOverride(colors);
        this.borderColor = style.value(PName.LineColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet());
        this.shadowing = style.value(PName.Shadowing).asDouble();
        this.stroke = style.getStroke(colors);
        this.roundCorner = style.value(PName.RoundCorner).asDouble();
        this.diagonalCorner = style.value(PName.DiagonalCorner).asDouble();
        this.back = specificBackColor == null ? style.value(PName.BackGroundColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet()) : specificBackColor;
        FontConfiguration titleFontConfiguration = style.getFontConfiguration(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet());
        HorizontalAlignment titleHorizontalAlignment = style.getHorizontalAlignment();
        this.desc = entity.getDisplay().create(titleFontConfiguration, titleHorizontalAlignment, skinParam);
        DisplayPositioned legend = ((EntityImpl)entity).getLegend();
        this.stereoBlock = legend != null ? (legendBlock = EntityImageLegend.create(legend.getDisplay(), skinParam)) : (this.stereotype == null || this.stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR) == null || !portionShower.showPortion(EntityPortion.STEREOTYPE, entity) ? TextBlockUtils.empty(0.0, 0.0) : TextBlockUtils.withMargin(Display.create(this.stereotype.getLabels(skinParam.guillemet())).create(FontConfiguration.create(this.getSkinParam(), FontParam.PACKAGE_STEREOTYPE, this.stereotype), titleHorizontalAlignment, skinParam), 1.0, 0.0));
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimDesc = this.desc.calculateDimension(stringBounder);
        Dimension2D dim = TextBlockUtils.mergeTB(this.desc, this.stereoBlock, HorizontalAlignment.LEFT).calculateDimension(stringBounder);
        dim = Dimension2DDouble.atLeast(dim, 0.0, 2.0 * dimDesc.getHeight());
        return Dimension2DDouble.delta(dim, 20.0, 20.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimTotal = this.calculateDimension(stringBounder);
        double widthTotal = dimTotal.getWidth();
        double heightTotal = dimTotal.getHeight();
        ClusterDecoration decoration = new ClusterDecoration(this.getSkinParam().packageStyle(), null, this.desc, this.stereoBlock, 0.0, 0.0, widthTotal, heightTotal, this.stroke);
        HorizontalAlignment horizontalAlignment = this.getSkinParam().getHorizontalAlignment(AlignmentParam.packageTitleAlignment, null, false, null);
        HorizontalAlignment stereotypeAlignment = this.getSkinParam().getStereotypeAlignment();
        decoration.drawU(ug, this.back, this.borderColor, this.shadowing, this.roundCorner, horizontalAlignment, stereotypeAlignment, this.diagonalCorner);
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }
}

