/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.image;

import java.awt.geom.Rectangle2D;
import java.util.EnumMap;
import znaishaded.net.sourceforge.plantuml.CornerParam;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.Guillemet;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.LineConfigurable;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.creole.Stencil;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.EntityPortion;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.PortionShower;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.InnerStrategy;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockEmpty;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockLineBefore;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.svek.AbstractEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.Ports;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.svek.WithPorts;
import znaishaded.net.sourceforge.plantuml.ugraphic.PlacementStrategyY1Y2;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGroupType;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULayoutGroup;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class EntityImageObject
extends AbstractEntityImage
implements Stencil,
WithPorts {
    private final TextBlock name;
    private final TextBlock stereo;
    private final TextBlock fields;
    private final Url url;
    private final double roundCorner;
    private final LineConfigurable lineConfig;
    private int marginEmptyFieldsOrMethod = 13;
    private int xMarginCircle = 5;

    public EntityImageObject(ILeaf entity, ISkinParam skinParam, PortionShower portionShower) {
        super(entity, skinParam);
        this.lineConfig = entity;
        Stereotype stereotype = entity.getStereotype();
        this.roundCorner = skinParam.getRoundCorner(CornerParam.DEFAULT, null);
        FontConfiguration fcHeader = this.getStyleHeader().getFontConfiguration(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet());
        TextBlock tmp = this.getUnderlinedName(entity).create(fcHeader, HorizontalAlignment.CENTER, skinParam);
        this.name = TextBlockUtils.withMargin(tmp, 2.0, 2.0);
        this.stereo = stereotype == null || stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR) == null || !portionShower.showPortion(EntityPortion.STEREOTYPE, entity) ? null : Display.create(stereotype.getLabels(skinParam.guillemet())).create(FontConfiguration.create(this.getSkinParam(), FontParam.OBJECT_STEREOTYPE, stereotype), HorizontalAlignment.CENTER, skinParam);
        boolean showFields = portionShower.showPortion(EntityPortion.FIELD, entity);
        this.fields = entity.getBodier().getFieldsToDisplay().size() == 0 ? new TextBlockLineBefore(this.getStyle().value(PName.LineThickness).asDouble(), new TextBlockEmpty(10.0, 16.0)) : entity.getBodier().getBody(FontParam.OBJECT_ATTRIBUTE, skinParam, false, showFields, entity.getStereotype(), this.getStyle(), null);
        this.url = entity.getUrl99();
    }

    private Style getStyle() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.objectDiagram, SName.object).withTOBECHANGED(this.getEntity().getStereotype()).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
    }

    private Style getStyleHeader() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.objectDiagram, SName.object, SName.header).withTOBECHANGED(this.getEntity().getStereotype()).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
    }

    private Display getUnderlinedName(ILeaf entity) {
        if (this.getSkinParam().strictUmlStyle()) {
            return entity.getDisplay().underlinedName();
        }
        return entity.getDisplay();
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimTitle = this.getTitleDimension(stringBounder);
        Dimension2D dimFields = this.fields.calculateDimension(stringBounder);
        double width = Math.max(dimFields.getWidth(), dimTitle.getWidth() + (double)(2 * this.xMarginCircle));
        if (width < this.getSkinParam().minClassWidth()) {
            width = this.getSkinParam().minClassWidth();
        }
        double height = this.getMethodOrFieldHeight(dimFields) + dimTitle.getHeight();
        return new Dimension2DDouble(width, height);
    }

    @Override
    public final void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimTotal = this.calculateDimension(stringBounder);
        Dimension2D dimTitle = this.getTitleDimension(stringBounder);
        double widthTotal = dimTotal.getWidth();
        double heightTotal = dimTotal.getHeight();
        URectangle rect = new URectangle(widthTotal, heightTotal).rounded(this.roundCorner);
        HColor backcolor = this.getEntity().getColors().getColor(ColorType.BACK);
        HColor headerBackcolor = this.getEntity().getColors().getColor(ColorType.HEADER);
        Style style = this.getStyle();
        HColor borderColor = style.value(PName.LineColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet());
        if (headerBackcolor == null) {
            HColor hColor = headerBackcolor = backcolor == null ? this.getStyleHeader().value(PName.BackGroundColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet()) : backcolor;
        }
        if (backcolor == null) {
            backcolor = style.value(PName.BackGroundColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet());
        }
        rect.setDeltaShadow(style.value(PName.Shadowing).asDouble());
        UStroke stroke = style.getStroke();
        ug = ug.apply(borderColor).apply(backcolor.bg());
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        EnumMap<UGroupType, String> typeIDent = new EnumMap<UGroupType, String>(UGroupType.class);
        typeIDent.put(UGroupType.CLASS, "elem " + this.getEntity().getCode() + " selected");
        typeIDent.put(UGroupType.ID, "elem_" + this.getEntity().getCode());
        ug.startGroup(typeIDent);
        ug.apply(stroke).draw(rect);
        if (this.roundCorner == 0.0 && headerBackcolor != null && !backcolor.equals(headerBackcolor)) {
            URectangle rect2 = new URectangle(widthTotal, dimTitle.getHeight());
            UGraphic ugHeader = ug.apply(headerBackcolor.bg());
            ugHeader.apply(stroke).draw(rect2);
        }
        ULayoutGroup header = this.getLayout(stringBounder);
        header.drawU(ug, dimTotal.getWidth(), dimTitle.getHeight());
        UGraphic ug2 = UGraphicStencil.create(ug, this, stroke);
        this.fields.drawU(ug2.apply(UTranslate.dy(dimTitle.getHeight())));
        if (this.url != null) {
            ug.closeUrl();
        }
        ug.closeGroup();
    }

    private ULayoutGroup getLayout(StringBounder stringBounder) {
        ULayoutGroup header = new ULayoutGroup(new PlacementStrategyY1Y2(stringBounder));
        if (this.stereo != null) {
            header.add(this.stereo);
        }
        header.add(this.name);
        return header;
    }

    private double getMethodOrFieldHeight(Dimension2D dim) {
        double fieldsHeight = dim.getHeight();
        if (fieldsHeight == 0.0) {
            return this.marginEmptyFieldsOrMethod;
        }
        return fieldsHeight;
    }

    private Dimension2D getTitleDimension(StringBounder stringBounder) {
        return this.getNameAndSteretypeDimension(stringBounder);
    }

    private Dimension2D getNameAndSteretypeDimension(StringBounder stringBounder) {
        Dimension2D nameDim = this.name.calculateDimension(stringBounder);
        Dimension2D stereoDim = this.stereo == null ? new Dimension2DDouble(0.0, 0.0) : this.stereo.calculateDimension(stringBounder);
        Dimension2DDouble nameAndStereo = new Dimension2DDouble(Math.max(nameDim.getWidth(), stereoDim.getWidth()), nameDim.getHeight() + stereoDim.getHeight());
        return nameAndStereo;
    }

    @Override
    public ShapeType getShapeType() {
        if (((ILeaf)this.getEntity()).getPortShortNames().size() > 0) {
            return ShapeType.RECTANGLE_HTML_FOR_PORTS;
        }
        return ShapeType.RECTANGLE;
    }

    @Override
    public double getStartingX(StringBounder stringBounder, double y) {
        return 0.0;
    }

    @Override
    public double getEndingX(StringBounder stringBounder, double y) {
        return this.calculateDimension(stringBounder).getWidth();
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        Dimension2D dimHeader = this.getNameAndSteretypeDimension(stringBounder);
        if (this.fields instanceof WithPorts) {
            return ((WithPorts)((Object)this.fields)).getPorts(stringBounder).translateY(dimHeader.getHeight());
        }
        return new Ports();
    }

    @Override
    public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
        Dimension2D dimTitle = this.getTitleDimension(stringBounder);
        UTranslate translate = UTranslate.dy(dimTitle.getHeight());
        return translate.apply(this.fields.getInnerPosition(member, stringBounder, strategy));
    }
}

