/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.syntax;

import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.BlockUml;
import znaishaded.net.sourceforge.plantuml.ErrorUml;
import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.LineLocationImpl;
import znaishaded.net.sourceforge.plantuml.OptionFlags;
import znaishaded.net.sourceforge.plantuml.SourceStringReader;
import znaishaded.net.sourceforge.plantuml.UmlDiagram;
import znaishaded.net.sourceforge.plantuml.core.Diagram;
import znaishaded.net.sourceforge.plantuml.error.PSystemError;
import znaishaded.net.sourceforge.plantuml.preproc.Defines;
import znaishaded.net.sourceforge.plantuml.syntax.SyntaxResult;

public class SyntaxChecker {
    public static SyntaxResult checkSyntax(List<String> source) {
        StringBuilder sb = new StringBuilder();
        for (String s2 : source) {
            sb.append(s2);
            sb.append("\n");
        }
        return SyntaxChecker.checkSyntax(sb.toString());
    }

    public static SyntaxResult checkSyntax(String source) {
        OptionFlags.getInstance().setQuiet(true);
        SyntaxResult result = new SyntaxResult();
        if (!source.startsWith("@startuml\n")) {
            result.setError(true);
            result.setLineLocation(new LineLocationImpl("", null).oneLineRead());
            result.addErrorText("No @startuml/@enduml found");
            return result;
        }
        if (!source.endsWith("@enduml\n") && !source.endsWith("@enduml")) {
            result.setError(true);
            result.setLineLocation(SyntaxChecker.lastLineNumber2(source));
            result.addErrorText("No @enduml found");
            return result;
        }
        SourceStringReader sourceStringReader = new SourceStringReader(Defines.createEmpty(), source, Collections.emptyList());
        List<BlockUml> blocks = sourceStringReader.getBlocks();
        if (blocks.size() == 0) {
            result.setError(true);
            result.setLineLocation(SyntaxChecker.lastLineNumber2(source));
            result.addErrorText("No @enduml found");
            return result;
        }
        Diagram system = blocks.get(0).getDiagram();
        result.setCmapData(system.hasUrl());
        if (system instanceof UmlDiagram) {
            result.setUmlDiagramType(((UmlDiagram)system).getUmlDiagramType());
            result.setDescription(system.getDescription().getDescription());
        } else if (system instanceof PSystemError) {
            result.setError(true);
            PSystemError sys = (PSystemError)system;
            result.setLineLocation(sys.getLineLocation());
            result.setSystemError(sys);
            for (ErrorUml er : sys.getErrorsUml()) {
                result.addErrorText(er.getError());
            }
        } else {
            result.setDescription(system.getDescription().getDescription());
        }
        return result;
    }

    public static SyntaxResult checkSyntaxFair(String source) {
        SyntaxResult result = new SyntaxResult();
        SourceStringReader sourceStringReader = new SourceStringReader(Defines.createEmpty(), source, Collections.emptyList());
        List<BlockUml> blocks = sourceStringReader.getBlocks();
        if (blocks.size() == 0) {
            result.setError(true);
            result.setLineLocation(SyntaxChecker.lastLineNumber2(source));
            result.addErrorText("No @enduml found");
            return result;
        }
        Diagram system = blocks.get(0).getDiagram();
        result.setCmapData(system.hasUrl());
        if (system instanceof UmlDiagram) {
            result.setUmlDiagramType(((UmlDiagram)system).getUmlDiagramType());
            result.setDescription(system.getDescription().getDescription());
        } else if (system instanceof PSystemError) {
            result.setError(true);
            PSystemError sys = (PSystemError)system;
            result.setLineLocation(sys.getLineLocation());
            for (ErrorUml er : sys.getErrorsUml()) {
                result.addErrorText(er.getError());
            }
            result.setSystemError(sys);
        } else {
            result.setDescription(system.getDescription().getDescription());
        }
        return result;
    }

    private static int lastLineNumber(String source) {
        int result = 0;
        for (int i = 0; i < source.length(); ++i) {
            if (source.charAt(i) != '\n') continue;
            ++result;
        }
        return result;
    }

    private static LineLocation lastLineNumber2(String source) {
        LineLocationImpl result = new LineLocationImpl("", null).oneLineRead();
        for (int i = 0; i < source.length(); ++i) {
            if (source.charAt(i) != '\n') continue;
            result = result.oneLineRead();
        }
        return result;
    }
}

