/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.tim.stdlib;

import java.util.List;
import java.util.Map;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.OptionFlags;
import znaishaded.net.sourceforge.plantuml.security.SecurityUtils;
import znaishaded.net.sourceforge.plantuml.tim.EaterException;
import znaishaded.net.sourceforge.plantuml.tim.EaterExceptionLocated;
import znaishaded.net.sourceforge.plantuml.tim.TContext;
import znaishaded.net.sourceforge.plantuml.tim.TFunctionSignature;
import znaishaded.net.sourceforge.plantuml.tim.TMemory;
import znaishaded.net.sourceforge.plantuml.tim.expression.TValue;
import znaishaded.net.sourceforge.plantuml.tim.stdlib.SimpleReturnFunction;

public class Getenv
extends SimpleReturnFunction {
    @Override
    public TFunctionSignature getSignature() {
        return new TFunctionSignature("%getenv", 1);
    }

    @Override
    public boolean canCover(int nbArg, Set<String> namedArgument) {
        return nbArg == 1;
    }

    @Override
    public TValue executeReturnFunction(TContext context, TMemory memory, LineLocation location, List<TValue> values, Map<String, TValue> named) throws EaterException, EaterExceptionLocated {
        if (!OptionFlags.ALLOW_INCLUDE) {
            return TValue.fromString("");
        }
        String name = values.get(0).toString();
        String value = this.getenv(name);
        if (value == null) {
            return TValue.fromString("");
        }
        return TValue.fromString(value);
    }

    private String getenv(String name) {
        if (SecurityUtils.isSecurityEnv(name)) {
            return null;
        }
        String env = System.getProperty(name);
        if (env != null) {
            return env;
        }
        return System.getenv(name);
    }
}

