/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.net.sourceforge.plantuml.SignatureUtils;
import znaishaded.net.sourceforge.plantuml.ugraphic.UShape;

public class UImageSvg
implements UShape {
    private final String svg;
    private final double scale;

    public UImageSvg(String svg, double scale) {
        this.svg = Objects.requireNonNull(svg);
        this.scale = scale;
    }

    public String getMD5Hex() {
        return SignatureUtils.getMD5Hex(this.svg);
    }

    public boolean containsXlink() {
        return this.svg.contains("xmlns:xlink=\"http://www.w3.org/1999/xlink\"");
    }

    public String getSvg(boolean raw) {
        String background;
        String style;
        int idx;
        String result = this.svg;
        if (raw) {
            return result;
        }
        if (result.startsWith("<?xml")) {
            idx = result.indexOf("<svg");
            result = result.substring(idx);
        }
        if (result.startsWith("<svg")) {
            idx = result.indexOf(">");
            result = "<svg>" + result.substring(idx + 1);
        }
        if ((style = this.extractSvgStyle()) != null && (background = this.extractBackground(style)) != null) {
            result = result.replaceFirst("<g>", "<g><rect fill=\"" + background + "\" style=\"" + style + "\" /> ");
        }
        if (!result.startsWith("<svg>")) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    private String extractBackground(String style) {
        Pattern p = Pattern.compile("background:([^;]+)");
        Matcher m3 = p.matcher(style);
        if (m3.find()) {
            return m3.group(1);
        }
        return null;
    }

    private String extractSvgStyle() {
        Pattern p = Pattern.compile("(?i)\\<svg[^>]+style=\"([^\">]+)\"");
        Matcher m3 = p.matcher(this.svg);
        if (m3.find()) {
            return m3.group(1);
        }
        return null;
    }

    public int getData(String name) {
        Pattern p = Pattern.compile("(?i)<svg[^>]+" + name + "\\W+(\\d+)");
        Matcher m3 = p.matcher(this.svg);
        if (m3.find()) {
            String s2 = m3.group(1);
            return Integer.parseInt(s2);
        }
        Pattern p2 = Pattern.compile("viewBox[= \"']+([0-9.]+)[\\s,]+([0-9.]+)[\\s,]+([0-9.]+)[\\s,]+([0-9.]+)");
        Matcher m22 = p2.matcher(this.svg);
        if (m22.find()) {
            if ("width".equals(name)) {
                String s3 = m22.group(3);
                int width = (int)Double.parseDouble(s3);
                return width;
            }
            if ("height".equals(name)) {
                String s4 = m22.group(4);
                int result = (int)Double.parseDouble(s4);
                return result;
            }
        }
        throw new IllegalStateException("Cannot find " + name);
    }

    public double getHeight() {
        return (double)this.getData("height") * this.scale;
    }

    public double getWidth() {
        return (double)this.getData("width") * this.scale;
    }

    public double getScale() {
        return this.scale;
    }
}

