/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic.color;

import java.awt.Color;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorBackground;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public abstract class AbstractColorMapper
implements ColorMapper {
    @Override
    public final String toRGB(HColor hcolor) {
        if (hcolor == null) {
            return null;
        }
        Color color = this.toColor(hcolor);
        return StringUtils.sharp000000(color.getRGB());
    }

    @Override
    public final String toSvg(HColor hcolor) {
        if (hcolor == null) {
            return "none";
        }
        if (hcolor instanceof HColorBackground) {
            hcolor = ((HColorBackground)hcolor).getBack();
        }
        if (HColorUtils.isTransparent(hcolor)) {
            return "#00000000";
        }
        Color color = this.toColor(hcolor);
        int alpha = color.getAlpha();
        if (alpha == 255) {
            return this.toRGB(hcolor);
        }
        String s2 = "0" + Integer.toHexString(alpha).toUpperCase();
        s2 = s2.substring(s2.length() - 2);
        return this.toRGB(hcolor) + s2;
    }

    private static String sharpAlpha(int color) {
        int v = color & 0xFFFFFF;
        String s2 = "00000" + Integer.toHexString(v).toUpperCase();
        s2 = s2.substring(s2.length() - 6);
        int alpha = (int)((long)color & 0xFFL) << 24;
        String s22 = "0" + Integer.toHexString(alpha).toUpperCase();
        return "#" + s2 + s22.substring(0, 2);
    }
}

