/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic.eps;

import java.io.IOException;
import java.io.OutputStream;
import znaishaded.net.sourceforge.plantuml.FileFormat;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.eps.EpsGraphics;
import znaishaded.net.sourceforge.plantuml.eps.EpsStrategy;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.UDrawable;
import znaishaded.net.sourceforge.plantuml.posimo.DotPath;
import znaishaded.net.sourceforge.plantuml.ugraphic.AbstractCommonUGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.AbstractUGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ClipContainer;
import znaishaded.net.sourceforge.plantuml.ugraphic.UCenteredCharacter;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UImage;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPath;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPolygon;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UText;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.eps.DriverCenteredCharacterEps;
import znaishaded.net.sourceforge.plantuml.ugraphic.eps.DriverDotPathEps;
import znaishaded.net.sourceforge.plantuml.ugraphic.eps.DriverEllipseEps;
import znaishaded.net.sourceforge.plantuml.ugraphic.eps.DriverImageEps;
import znaishaded.net.sourceforge.plantuml.ugraphic.eps.DriverLineEps;
import znaishaded.net.sourceforge.plantuml.ugraphic.eps.DriverPathEps;
import znaishaded.net.sourceforge.plantuml.ugraphic.eps.DriverPolygonEps;
import znaishaded.net.sourceforge.plantuml.ugraphic.eps.DriverRectangleEps;
import znaishaded.net.sourceforge.plantuml.ugraphic.eps.DriverTextEps;

public class UGraphicEps
extends AbstractUGraphic<EpsGraphics>
implements ClipContainer {
    private final EpsStrategy strategyTOBEREMOVED;

    @Override
    protected AbstractCommonUGraphic copyUGraphic() {
        return new UGraphicEps(this);
    }

    protected UGraphicEps(UGraphicEps other) {
        super(other);
        this.strategyTOBEREMOVED = other.strategyTOBEREMOVED;
        this.register();
    }

    public UGraphicEps(HColor defaultBackground, ColorMapper colorMapper, StringBounder stringBounder, EpsStrategy strategy) {
        super(defaultBackground, colorMapper, stringBounder, strategy.creatEpsGraphics());
        this.strategyTOBEREMOVED = strategy;
        this.register();
    }

    private void register() {
        this.registerDriver(URectangle.class, new DriverRectangleEps(this));
        this.registerDriver(UText.class, new DriverTextEps(this, this.strategyTOBEREMOVED));
        this.registerDriver(ULine.class, new DriverLineEps(this));
        this.registerDriver(UPolygon.class, new DriverPolygonEps(this));
        this.registerDriver(UEllipse.class, new DriverEllipseEps(this));
        this.registerDriver(UImage.class, new DriverImageEps(this));
        this.registerDriver(UPath.class, new DriverPathEps());
        this.registerDriver(DotPath.class, new DriverDotPathEps());
        this.registerDriver(UCenteredCharacter.class, new DriverCenteredCharacterEps());
    }

    public void close() {
        this.getEpsGraphics().close();
    }

    public String getEPSCode() {
        return this.getEpsGraphics().getEPSCode();
    }

    public EpsGraphics getEpsGraphics() {
        return (EpsGraphics)this.getGraphicObject();
    }

    public void drawEps(String eps, double x, double y) {
        ((EpsGraphics)this.getGraphicObject()).drawEps(eps, x, y);
    }

    public static String getEpsString(HColor defaultBackground, ColorMapper colorMapper, EpsStrategy epsStrategy, UDrawable udrawable) throws IOException {
        UGraphicEps ug = new UGraphicEps(defaultBackground, colorMapper, FileFormat.EPS_TEXT.getDefaultStringBounder(), epsStrategy);
        udrawable.drawU(ug);
        return ug.getEPSCode();
    }

    @Override
    public void startUrl(Url url) {
        ((EpsGraphics)this.getGraphicObject()).openLink(url.getUrl());
    }

    @Override
    public void closeUrl() {
        ((EpsGraphics)this.getGraphicObject()).closeLink();
    }

    @Override
    public void writeToStream(OutputStream os, String metadata, int dpi) throws IOException {
        os.write(this.getEPSCode().getBytes());
    }
}

