/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic.hand;

import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import java.util.Random;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPath;
import znaishaded.net.sourceforge.plantuml.ugraphic.USegment;
import znaishaded.net.sourceforge.plantuml.ugraphic.USegmentType;
import znaishaded.net.sourceforge.plantuml.ugraphic.hand.HandJiggle;

public class UPathHand {
    private final UPath path;
    private final double defaultVariation = 4.0;

    public UPathHand(UPath source, Random rnd) {
        UPath result = new UPath();
        Point2D.Double last = new Point2D.Double();
        for (USegment segment : source) {
            HandJiggle jiggle;
            double y;
            double x;
            USegmentType type = segment.getSegmentType();
            if (type == USegmentType.SEG_MOVETO) {
                x = segment.getCoord()[0];
                y = segment.getCoord()[1];
                result.moveTo(x, y);
                last = new Point2D.Double(x, y);
                continue;
            }
            if (type == USegmentType.SEG_CUBICTO) {
                double x2 = segment.getCoord()[4];
                double y2 = segment.getCoord()[5];
                jiggle = HandJiggle.create(last, 2.0, rnd);
                CubicCurve2D.Double tmp = new CubicCurve2D.Double(((Point2D)last).getX(), ((Point2D)last).getY(), segment.getCoord()[0], segment.getCoord()[1], segment.getCoord()[2], segment.getCoord()[3], x2, y2);
                jiggle.curveTo(tmp);
                jiggle.appendTo(result);
                last = new Point2D.Double(x2, y2);
                continue;
            }
            if (type == USegmentType.SEG_LINETO) {
                x = segment.getCoord()[0];
                y = segment.getCoord()[1];
                jiggle = new HandJiggle(((Point2D)last).getX(), ((Point2D)last).getY(), 4.0, rnd);
                jiggle.lineTo(x, y);
                for (USegment seg2 : jiggle.toUPath()) {
                    if (seg2.getSegmentType() != USegmentType.SEG_LINETO) continue;
                    result.lineTo(seg2.getCoord()[0], seg2.getCoord()[1]);
                }
                last = new Point2D.Double(x, y);
                continue;
            }
            if (type == USegmentType.SEG_ARCTO) {
                x = segment.getCoord()[5];
                y = segment.getCoord()[6];
                result.lineTo(x, y);
                last = new Point2D.Double(x, y);
                continue;
            }
            this.path = source;
            return;
        }
        this.path = result;
        this.path.setDeltaShadow(source.getDeltaShadow());
    }

    public UPath getHanddrawn() {
        return this.path;
    }
}

